<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Core\Helpers;
use Mnv\Models\Banners;

/**
 * Class BannerAdmin
 * @package Mnv\Admin\Controllers
 */
class BannerAdmin extends AdminMnv
{

	public function fetch()
    {

        $bannerImage = new Banners($this->request);

        $image    = $this->request->get('image', '');
        $gallery  = $this->request->get('gallery', '');
        $docs     = $this->request->get('docs', '');

        $imageId = (int) $this->request->get('imageId');
        $imageIds = $this->request->get('imageIds', '');
        $picture  = $this->request->get('picture', '');

        $this->smarty->assign('activeItem','banners');
        $this->smarty->assign('title', 'Банер');
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));
        $this->smarty->assign('sections', Helpers::getAllSectionOptions());


        if ($this->action == 'add' || $this->action == 'edit') {

            $bannerImage->edit()->getFiles()->gettingInfoAboutUsers();
        }
        /** сохранение данных */
        elseif ($this->action == 'save' || $this->action == 'apply') {

            if (empty($bannerImage->data['title'])) $this->errors['title'] = true;
            if (empty($bannerImage->sectionIds)) $this->errors['sectionIds'] = true;

            /** основная картинка */
            $images['general'] = !empty($image) ? $image : null;
            /** включить / отключить галерею у данного контента */
            $bannerImage->data['enableGallery'] = isset($bannerImage->data['enableGallery']) ? 1 : 0;
            $images['gallery'] = !empty($gallery) ? $gallery : null;
            if (isset($docs)) $images['docs'] = !empty($docs) ? $docs : '';

            if (empty($this->errors)) {
                if ($bannerImage->prepare($bannerImage->data, $this->manager['userId'])) {
                    $bannerImage->pages();

                    if (!empty($images['general'])) $bannerImage->addFiles($bannerImage->id, $images);
                    if (!empty($images['gallery'])) $bannerImage->addFiles($bannerImage->id, $images, 'gallery');
                    if (!empty($images['docs'])) $bannerImage->addFiles($bannerImage->id, $images, 'docs');

                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $bannerImage->edit()->getFiles()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString("banners", ['page' => $this->page]));
            }

        }
        /** удаление (основной картинки / из галереи / docs */
        elseif ($this->action == 'deleteFile') {
            $result = $bannerImage->deleteFile($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingFile'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingFileError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** удаление основной картинки */
        elseif ($this->action == 'editPictureInfo') {
            $response = $bannerImage->editPicture($imageId, $picture)
                ? array('status' => 200, 'title' => $bannerImage->result['title'], 'alias' => $bannerImage->result['alias'], 'description' => $bannerImage->result['description'], 'link' => $bannerImage->result['link'], 'position' => $bannerImage->result['position'])
                : array('status' => 400, 'title' => '', 'alias' => '', 'description' => '', 'link' => '', 'position' => '');

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка картинок в галерее */
        elseif ($this->action == 'sortPictures') {

            $i = 0;
            foreach ($imageIds as  $imageId) {
                $i++;
                $bannerImage->sortingPictures($imageId, $i);
            }

            response()->json(array('status' => 200, 'type' => 'success'), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** удаление картинок из галерее */
        elseif ($this->action == 'deletePicture') {
            $result = $bannerImage->deleteFile($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        if (!empty($bannerImage->id)) {
            $bannerImage->sectionIds =  $bannerImage->sectionIds();
        }


        $this->smarty->assign('sectionIds',  $bannerImage->sectionIds);
        $this->smarty->assign('banner',  $bannerImage->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }


        if ($this->permissions('banners')) {
            return $this->smarty->fetch('views/banners/banner.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }


}