<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;


use Mnv\Models\Banners;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Core\Database\Throwable\DatabaseException;

/**
 * Class BannersAdmin
 * @package Mnv\Admin\Controllers
 */
class BannersAdmin extends AdminMnv
{

	public function fetch()
    {

        $bannerImage = new Banners($this->request);

        $this->smarty->assign('activeItem','banners');
        $this->smarty->assign('title','Баннеры');

        /** удаление */
        if ($this->action == 'remove') {
            try {
                $bannerImage->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // Баннер удален
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $bannerImage->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** изменение статуса */
        elseif ($this->action == 'status') {
            try {
                $bannerImage->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $bannerImage->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $bannerImage->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }
        /** сортировка */
        elseif ($this->action == 'reorder') {
            $i = 0;
            $bannerImage->data = [];
            foreach ($bannerImage->bannerIds as $bannerId) {
                $i++;
                $bannerImage->id = $bannerId;
                $bannerImage->data['orderBy'] = $i;
                $bannerImage->update($bannerImage->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }

        $bannerImages = collect($bannerImage->all($this->limit, $this->page))->map(function ($item) use ($bannerImage) {
            $item['image']    = !empty($item['image']['small']) ? $item['image']['small'] : '/admin/assets/images/no_images.jpg';
            $item['sections'] = $bannerImage->sections($item['bannerId']);

            return $item;
        })->all();


        $bannerImage->total();
        $pages = getPageNums($bannerImage->total, $this->page, $this->limit, 0, 4, 4, 0);

        $this->smarty->assign('totalBanners', $bannerImage->total);
        $this->smarty->assign('banners',  $bannerImages);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('banners')) {
            return $this->smarty->fetch('views/banners/banners.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}