<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Models\Cars\CarModels;
use Mnv\Models\Cars\Colors;
use Mnv\Models\Cars\Equipments;


/**
 * Class CarColorAdmin
 * @package Mnv\Admin\Controllers
 */
class CarColorAdmin extends AdminMnv
{
    /**
     * @var string
     */
    private $typeContent;

    public function fetch()
    {
        $colors = new Colors($this->request);

        $title = ($this->module == 'bcolor') ? 'Цвет кузова' : 'Цвет салона';

        $this->typeContent   = $this->module .'s';

        $this->smarty->assign('activeItem', $this->typeContent);
        $this->smarty->assign('title', $title);
        /* statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module . 's');

        $this->smarty->assign('models', CarModels::getModels());


        if ($this->action == 'add' || $this->action == 'edit') {
            $colors->edit();
        } else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($colors->data['colorName'])) $this->errors['title'] = true;
            if (empty($colors->modelIds)) $this->errors['modelIds'] = true;

            /** тип контента */
            if (empty($content->data['typeContent'])) $colors->data['colorType'] = $this->typeContent;

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                if ($colors->prepare($colors->data, $this->module, $this->manager['userId'])) {

                    $colors->updateColorModels($this->typeContent);

                    $this->messages['saved'] = true;

                } else {
                    $this->errors['not_saved'] = true;
                }

            }

            $colors->edit();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString($this->module . 's', ['page' => $this->page]));
            }

        }

        if (!empty($colors->id)) {
            $colors->data['modelIds'] = $colors->getSelectedModels($colors->id);
        }

        $this->smarty->assign('color', $colors->data);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if ($this->permissions($this->module.'s')) {
            return $this->smarty->fetch('views/cars/' . $this->module .'.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}