<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Deal;

/**
 * Class OrderStatusesAdmin
 * @package Mnv\Admin\Controllers
 */
class CarDealAdmin extends AdminMnv
{

    public function fetch()
    {
        $deal = new Deal($this->request);

        $this->smarty->assign('activeItem','deal');
        $this->smarty->assign('title', 'Варианты сделок');

       if ($this->action == 'save' || $this->action == 'apply') {
           try {
               $deal->prepare();
               $this->messages['saved'] = true;
           } catch (\InvalidArgumentException $e) {
               $this->errors['message'] = $e->getMessage();
               $this->errors['not_saved'] = true;
           }
        }


        /** получение всех соц. сетей */
        $deals = $deal->all(100, $this->page);

        $deal->total();
        $pages = getPageNums($deal->total, $this->page, $this->limit, 0, 4, 4, 0);

        /** вывод в шаблон результатов */
        $this->smarty->assign('deals', $deals);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        /** Права доступа к данному шаблону */
        if ($this->permissions('deal')) {
            return $this->smarty->fetch('views/cars/deal.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}



