<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Helpers;

use Mnv\Models\Cars\CarModels;
use Mnv\Models\Cars\Colors;
use Mnv\Models\Cars\Vehicle;
use Mnv\Models\Deal;
use Mnv\Models\Exceptions\NotUpdateContentException;
use Mnv\Models\Exceptions\NotInsertContentException;
use function Symfony\Component\Translation\t;

/**
 * Class CarModelAdmin
 * @package Mnv\Admin\Controllers
 */
class CarModelAdmin extends AdminMnv
{

    public function fetch()
    {
        global $SECTIONS;

        $content = new CarModels($this->request);

        /** работа с галереей */
        $image    = $this->request->get('image', '');
        $gallery  = $this->request->get('gallery', '');
        $docs     = $this->request->get('docs', '');

        $imageIds = $this->request->get('imageIds', '');
        $imageId  = (int) $this->request->get('imageId', '');
        $picture  = $this->request->get('picture', '');

        $colors   = $this->request->get('colors', '');

        $this->smarty->assign('gear_type',  $content->gear_types);
        $this->smarty->assign('test_drives', $content->test_drives);
        $this->smarty->assign('menus', $content->menus);
        $this->smarty->assign('specials',  $content->specials);
        $this->smarty->assign('dealTypes',  Deal::getDealTypes());


        $content->typeContent = $this->module . 's';
        /** title */
        $this->smarty->assign('title', 'Модели');
        /** activeItem */
        $this->smarty->assign('activeItem', $content->typeContent);
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $content->typeContent);
        /** statuses */
        $statuses = lang('general:statuses');
        array_shift($statuses);
        array_pop($statuses);
        $this->smarty->assign('statuses', $statuses);

//        $this->smarty->assign('urlTypes', array(
//            'default'   => 'Выбрать тип ссылки',
//            'modal'     => 'Модальное окно',
//            'external'  => 'Внешняя ссылка'
//        ));

//
//        $this->smarty->assign('bodyTypes', array());

        /** select isFeatured */
        $this->smarty->assign('paramIsFeatured', [
            0 => lang('general:no'),
            1 => lang('general:yes')
        ]);
        /** select commentsEnabled */
        $this->smarty->assign('paramSettingComments', [
            0   => lang('general:defaultComments'),
            -1  => lang('general:disableComments'),
            1   => lang('general:enableComments')
        ]);


        /** получить разделы данного типа контента */
        $sections = Helpers::getSectionContent(0, $content->typeContent);
        if (count($sections) < 2) $this->errors['no_sections'] = true;
        $this->smarty->assign('sections', $sections);

        if ($this->action === 'add' || $this->action === 'edit') {

            $content->edit()->getFiles()->gettingInfoAboutUsers()->getModeBColors()->getModeIColors();
        }
        /** сохранение */
        else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($content->data['title'])) {
                $this->errors['title'] = true;
            }
//            if (empty($content->data['typeId'])) {
//                $this->errors['typeId'] = true;
//            }
            /** избранное */
            $content->data['isFeatured'] = $content->data['isFeatured'] ?? 0;
            $content->data['test_drive'] = $content->data['test_drive'] ?? 0;

            /** проверка доступных разделов для статей */
            if (empty($content->data['sectionId']) || empty($sections[$content->data['sectionId']])) {
                $this->errors['sectionId'] = true;
            }

            /** проверка fileName на совпадение / если пустой то fileName пропишется от последнего ID из таблицы + 1 */
            if ($fileName = $content->checkFileName($content->data['fileName'])) {
                if ($fileName == $content->data['fileName']) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $content->data['fileName'] = $fileName;
                }
            }

            /** основная картинка */
            $images['general'] = !empty($image) ? $image : null;
            /** включить / отключить галерею у данного контента */
            $content->data['enableGallery'] = isset($content->data['enableGallery']) ? 1 : 0;
            $images['gallery'] = !empty($gallery) ? $gallery : null;
            /** файлы */
            $images['docs'] = !empty($docs) ? $docs : '';

            $content->data['paymentMethods'] = !empty($content->payments)
                ? json_encode($content->payments, JSON_UNESCAPED_UNICODE)
                : null;

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                /** построение url из полученного url раздела/fileName статьи . расширение файла из настроек  (html / htm)  */
                $content->data['url'] = $SECTIONS[$content->data['sectionId']]['path'] . '/'. $content->data['fileName'] . '/';

                if ($content->prepare($content->data, $this->manager['userId'])) {

                    if (!empty($images['general'])) $content->addFiles($content->id, $images);
                    if (!empty($images['gallery'])) $content->addFiles($content->id, $images, 'gallery');
                    if (!empty($images['docs'])) $content->addFiles($content->id, $images, 'docs');

//                    print_r($colors);
//                    if (is_array($colors)) {
//                        foreach ($colors as &$color) {
//                            $color['modelId']     = $content->id;
//                            if (empty($color['price'])) $color['price'] = '0.00';
//                            /** если уже существует цвета модели то обновляем его в противном случае добавляем */
//                            if (!empty($color['imageId'])) {
//                                /** обновляем цвет модели  */
//
//                                $content->updateColor($color['imageId'], $color);
//                            } else {
//                                /** добавление цвета модели */
//                                $content->addColor($color);
//                            }
//                        }
//                    }
                   $this->messages['saved'] = true;

                } else {
                    $this->errors['not_saved'] = true;
                }
            }


            $content->edit()->getFiles()->gettingInfoAboutUsers()->getModeBColors()->getModeIColors();

            if (empty($this->errors) && $this->action === 'save') {
//                $url = $this->buildQueryString('models', ['page' => $this->page]);
//                var_dump($url);
                redirect($this->buildQueryString('models', ['page' => $this->page]));
            }
        }
        /** удаление основной картинки */
        else if ($this->action == 'deleteFile') {
            $result = $content->deleteFile($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingFile'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingFileError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** удаление основной картинки */
        else if ($this->action == 'editPictureInfo') {
            $response = $content->editPicture($imageId, $picture)
                ? array('status' => 200, 'title' => $content->result['title'], 'alias' => $content->result['alias'], 'description' => $content->result['description'], 'link' => $content->result['link'], 'position' => $content->result['position'])
                : array('status' => 400, 'title' => '', 'alias' => '', 'description' => '', 'link' => '', 'position' => '');

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка картинок в галерее */
        else if ($this->action == 'sortPictures') {
            $result = $content->sortingPictures($imageIds)
                ? array('status' => 200, 'message' =>  lang('javascript:sortingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:sortingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
//        /** удаление картинок из галерее */
//        else if ($this->action == 'deletePicture') {
//
//            $result = $content->deleteFile($imageId)
//                ? array('status' => 200, 'message' => lang('javascript:deletingImage'), 'type' => 'success')
//                : array('status' => 500, 'message' => lang('javascript:deletingImageError'), 'type' => 'error');
//
//            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
//            exit();
//        }
//        /** удаление файлов docs */
//        else if ($this->action == 'deleteDocs') {
//
//            $result = $content->deleteFile($imageId)
//                ? array('status' => 200, 'message' => lang('javascript:deletingDocs'), 'type' => 'success')
//                : array('status' => 500, 'message' => lang('javascript:deletingDocsError'), 'type' => 'error');
//
//            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
//            exit();
//        }
        /** удаление картинки из галереи */
        else if ($this->action == 'deleteColors') {

            $result = $content->deleteColor($imageId)
                ? array('status' => 200, 'message' => 'Цвет удален', 'type' => 'success')
                : array('status' => 400, 'message' => 'Цвет не удален, обновить страницу и повторите удаление', 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка цвета (салона и кузова) */
        else if ($this->action == 'sortByColors') {
            $i = 0;
            foreach ($imageIds as  $imageId) {
                $i++;
                $content->sortByColors($imageId, $i);
            }

            response()->json(array('status' => 200, 'type' => 'success'), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** добавление модификации */
        else if ($this->action == 'add_modification') {
             if ($content->getModification()) {
                 $this->smarty->assign('modification', $content->modification);
                 $modification = $this->smarty->fetch('views/cars/items/modification.tpl');
                 $result = array('status' => 200, 'message' => 'Модификация добавлена', 'type' => 'success', 'modification' => $modification);
             } else {
                 $result = array('status' => 500, 'message' => 'Модификация НЕ добавлена', 'type' => 'error');
             }

             response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
             exit();
        }

        $totalPrice = 0;
        if (!empty($content->id)) {
            /** существующие модификации */
            $modifications = $content->getModifications();
            $this->smarty->assign('modifications', $modifications);
        }

        if (!empty($content->data['paymentMethods'])) {
            $content->data['paymentMethods'] = json_decode($content->data['paymentMethods'], true);
        }

        /** цвета кузова */
        $bColors = Colors::getModelColors($content->id ?? 0, 'bcolors');
        $this->smarty->assign('bcolors', $bColors);

        /** цвета салона */
        $iColors = Colors::getModelColors($content->id ?? 0, 'icolors');
        $this->smarty->assign('icolors', $iColors);

//        print_r($content->data);

        $this->smarty->assign('model', $content->data);
        $this->smarty->assign('totalPrice', $totalPrice);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);
        if (!empty($this->notice)) $this->smarty->assign('notice', $this->notice);
        $this->smarty->assign('module', $this->module);


        if ($this->permissions($this->module .'s')) {
            try {
                return $this->smarty->fetch('views/cars/model.tpl');
            } catch (\SmartyException | \Exception $e) {
                print $e->getMessage();
            }
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}