<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Models\Cars\CarEngine;
use Mnv\Models\Cars\CarGear;
use Mnv\Models\Cars\CarModels;
use Mnv\Models\Cars\CarTransmission;
use Mnv\Models\Cars\Modifications;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class CarModificationsAdmin
 * @package Mnv\Admin\Controllers
 */
class CarModificationsAdmin extends AdminMnv
{

    public function fetch()
    {
        $modification = new Modifications($this->request);

        /** title */
        $this->smarty->assign('title', 'Модификация');
        /** activeItem */
        $this->smarty->assign('activeItem', 'modifications');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module);

        $this->smarty->assign('engines', CarEngine::getEngines());
        $this->smarty->assign('transmissions',  CarTransmission::getTransmissions());
        $this->smarty->assign('gear_type',  CarGear::getGears());

        /** получить модели */
        $models = array('0' => 'Выберите модель...');
        $result = CarModels::getModels();
        if (!empty($result)) $models += $result;
        $this->smarty->assign('models', $models);

        /** удаление */
        if ($this->action == 'remove') {

            try {
                $modification->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // lang('articles:messages:2')
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();
        }
        /** изменение статуса */
        else if ($this->action == 'status') {
            try {
                $modification->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $modification->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $modification->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка */
        else if ($this->action == 'reorder') {

            $i = 0;
            $modification->data = [];
            foreach ($modification->modificationIds as $modificationId) {
                $i++;
                $modification->id = $modificationId;
                $modification->data['orderBy'] = $i;
                $modification->update($modification->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;

        }

        else {

            /** фильтровать контента */
            $modification->filter = array_filter([
                'status'        => $this->filter['status'] ?? '',
                'model_id'      => $this->filter['model'] ?? '',
                'query'         => $this->query,
            ]);

            $contents = collect($modification->all($this->limit, $this->page))->map(function ($item) use ($modification) {
                $item['statusName'] = lang('general:statuses:' . $item['status']);
                /** получить комплектации. */
                $item['model']              = $modification->getModel($item['modelId']);
                $item['engineName']         = CarEngine::getEngineName($item['engine']);
                $item['transmissionName']   = CarTransmission::getTransmissionName($item['transmission']);
                $item['gearName']           = CarGear::getGearName($item['gear']);

                return $item;
            })->all();

//            print_r($contents);

            /** pagination */
            $modification->total();
            $pages = getPageNums($modification->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalModifications', $modification->total);
            $this->smarty->assign('modifications', $contents);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('page', $this->page);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions('modifications')) {
            return $this->smarty->fetch('views/cars/modifications.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}