<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Models\Cars\Specifications;
use Mnv\Models\Cars\Equipments;
use Mnv\Models\Cars\Modifications;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class CarSpecificationsAdmin
 * @package Mnv\Admin\Controllers
 */
class CarSpecificationsAdmin extends AdminMnv
{

    public function fetch()
    {
        $specification = new Specifications($this->request);
        $equipments = new Equipments($this->request);

        /** title */
        $this->smarty->assign('title', 'Свойства спецификаций');
        /** activeItem */
        $this->smarty->assign('activeItem', 'specifications');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module);

        $this->smarty->assign('modifications', Modifications::getSelectModifications());
        /** Получение всех комплектации */
        $this->smarty->assign('equipments', $equipments->getEquipments());


        
        /** удаление */
        if ($this->action == 'remove') {
            try {
                $specification->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // lang('articles:messages:2')
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $specification->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();
        }
        /** изменение статуса */
        else if ($this->action == 'status') {
            try {
                $specification->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $specification->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $specification->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка */
        else if ($this->action == 'reorder') {

            $i = 0;
            $specification->data = [];
            foreach ($specification->specificationIds as $specificationId) {
                $i++;
                $specification->id = $specificationId;
                $specification->data['orderBy'] = $i;
                $specification->update($specification->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }
        else {

            /** фильтровать контента */
            $specification->filter = array_filter([
                'status'        => $this->filter['status'] ?? '',
                'query'         => $this->query,
            ]);

            $specifications = collect($specification->all($this->limit, $this->page))->map(function ($item) use ($specification) {
                $item['statusName'] = lang('general:statuses:' . $item['status']);
                return $item;
            })->all();

            /** pagination */
            $specification->total();
            $pages = getPageNums($specification->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $specification->total);
            $this->smarty->assign('specifications', $specifications);
            $this->smarty->assign('pageNums', $pages);

            $this->smarty->assign('page', $this->page);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions('specifications')) {
            return $this->smarty->fetch('views/cars/specifications.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}