<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Cars\CarTransmission;

/**
 * Class CarTransmissionAdmin
 * @package Mnv\Admin\Controllers
 */
class CarTransmissionAdmin extends AdminMnv
{
    /**
     * Вывод всего контента
     */
    public function fetch()
    {

        $block = new CarTransmission($this->request);

        $image    = $this->request->get('image', '');
        $imageId  = (int) $this->request->get('imageId', '');

        /** title */
        $this->smarty->assign('title', 'Трансмиссия');
        /** activeItem */
        $this->smarty->assign('activeItem', 'transmissions');
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module . 's');
        /** statuses */
        $statuses = lang('general:statuses');
        array_pop($statuses);
        $this->smarty->assign('statuses', $statuses);


        if ($this->action == 'add' || $this->action == 'edit') {
            $block->edit()->gettingInfoAboutUsers();
        } else if ($this->action == 'save' || $this->action == 'apply') {
            /** проверка полей */
            if (empty($block->data['name'])) $this->errors['name'] = true;

            /** основная картинка */
            $images['general'] = !empty($image) ? $image : null;
            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                if ($block->prepare($block->data, $this->manager['userId'])) {
                    if (!empty($images['general'])) $block->addFiles($block->id, $images);

                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $block->edit()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString("transmissions", ['page' => $this->page]));
            }

        }



        $this->smarty->assign('transmission', $block->data);


        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('transmissions')) {
            return $this->smarty->fetch('views/cars/transmission.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}