<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Models\Cars\CarTransmission;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class CarTransmissionsAdmin
 * @package Mnv\Admin\Controllers
 */
class CarTransmissionsAdmin extends AdminMnv
{

    public function fetch()
    {
        $gear = new CarTransmission($this->request);

        /** title */
        $this->smarty->assign('title', 'Трансмиссия');
        /** activeItem */
        $this->smarty->assign('activeItem', 'transmissions');
        /** statuses */
        $statuses = lang('general:statuses');
        array_shift($statuses);
        array_pop($statuses);
        $this->smarty->assign('statuses', $statuses);
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module);

        /** действия */
        if ($this->action == 'remove') {

            try {
                $gear->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // lang('articles:messages:2')
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();
        }
        /** статус */
        else if ($this->action == 'status') {
            try {
                $gear->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $gear->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $gear->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }  else if ($this->action == 'reorder') {
            $i = 0;
            $gear->data = [];
            foreach ($gear->gearIds as $gearId) {
                $i++;
                $gear->id = $gearId;
                $gear->data['orderBy'] = $i;
                $gear->update($gear->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;

        } else {

            /** фильтровать контента */
            $gear->filter = array_filter([
                'status'        => $this->filter['status'] ?? null,
                'query'         => $this->query,
            ]);

            /** получение всего контента */
            $transmissions = collect($gear->all($this->limit, $this->page))->map(function ($item) {
                $item['statusName']  = lang('general:statuses:' . $item['status']);

                return $item;
            })->all();

            /** pagination */
            $gear->total();
            $pages = getPageNums($gear->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalGears', $gear->total);
            $this->smarty->assign('transmissions', $transmissions);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('page', $this->page);

        }

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions('transmissions')) {
            return $this->smarty->fetch('views/cars/transmissions.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }


}