<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Models\Cars\CarModels;
use Mnv\Models\Cars\CarTypes;

/**
 * Class CarTypeAdmin
 * @package Mnv\Admin\Controllers
 */
class CarTypeAdmin extends AdminMnv
{

    public function fetch()
    {
        $vehicles = new CarTypes($this->request);

        $this->smarty->assign('title', 'Тип автотранспорта');
        $this->smarty->assign('activeItem', 'types');

        /** statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module . 's');

        /** получить модели */
        $models = array('0' => 'Выберите модель...');
        $models += CarModels::getModels();
        $this->smarty->assign('models', $models);

        if ($this->action == 'add' || $this->action == 'edit') {
            $vehicles->edit();
        }

        else if ($this->action == 'save' || $this->action == 'apply') {
            /** проверка полей */
            if (empty($vehicles->data['name'])) {
                $this->errors['title'] = true;
            }

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                if ($vehicles->prepare($vehicles->data, $this->manager['userId'])) {

                    if (is_array($vehicles->params)) {
                        $typeIds = array();

                        foreach($vehicles->params as &$param) {
                            if (!empty($param['typeId'])) {
                                $vehicles->updateBodyType($param['typeId'], $param);
                            } else {
                                $param['typeId'] = $vehicles->addBodyType($param);
                            }

                            $param = $vehicles->bodyType($param['typeId']); // ОШИБКА
                            if (!empty($param['typeId'])) {
                                $typeIds[] = $param['typeId'];
                            }
                        }

                        $currentBodyTypes = $vehicles->bodyTypes($vehicles->id);
                        /** Удаляем непереданные */
                        foreach($currentBodyTypes as $currentBodyType) {
                            if (!in_array($currentBodyType['typeId'], $typeIds, true)) {
                                $vehicles->removeBodyType($currentBodyType['typeId']);
                            }
                        }

                        /** Отсортировать */
                        asort($typeIds);
                        $i = 0;
                        foreach($typeIds as $typeId) {
                            $vehicles->updateBodyType($typeIds[$i], ['orderBy' => $typeId]);
                            $i++;
                        }
                    } else {
                        $currentBodyTypes = $vehicles->bodyTypes($vehicles->id);
                        /** Удаляем непереданные */
                        foreach($currentBodyTypes as $currentBodyType) {
                            $vehicles->removeBodyType($currentBodyType['typeId']);
                        }
                    }

                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }


            }

            $vehicles->edit();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString($this->module . "s", ['page' => $this->page]));
            }

        }

        $bodyTypes = [];
        if (!empty($vehicles->id)) {
            $bodyTypes = $vehicles->bodyTypes($vehicles->id);
        }

        $this->smarty->assign('bodyTypes', $bodyTypes);

        $this->smarty->assign('vehicle', $vehicles->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }

        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }


        if ($this->permissions('types')) {
            return $this->smarty->fetch('views/cars/type.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}