<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Helpers;
use Mnv\Models\Countries;
use Mnv\Models\Dealers;
use Mnv\Models\GeoCities;
use Mnv\Models\GeoCountries;

/**
 * Class DealersAdmin
 * @package Mnv\Admin\Controllers
 */
class DealersAdmin extends AdminMnv
{

    public function fetch()
    {
        global $SECTIONS;

        $block = new Dealers($this->request);

        /** title */
        $this->smarty->assign('title', 'Дилеры');
        /** activeItem */
        $this->smarty->assign('activeItem', 'dealers');
        /** statuses */
        $statuses = lang('general:statuses');
        array_pop($statuses);
        $this->smarty->assign('statuses', $statuses);

        $sections = Helpers::getSectionContent(0, 'dealers');
        $this->smarty->assign('sections', $sections);

        /** действия */
        if ($this->action == 'remove') {
            $result = $block->remove()
                ? array('status' => 200, 'message' => 'Дилер удален', 'type' => 'success')
                : array('status' => 403, 'message' => 'Ошибка при удаление дилера', 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** статус */
        else if ($this->action == 'status') {
            $result = $block->status()
                ? array('data' => true, 'status' => $block->status, 'type' => 'success')
                : array('data' => false, 'status' => $block->status, 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }  else if ($this->action == 'reorder') {
            $i = 0;
            $block->data = [];
            foreach ($block->blockIds as $blockId) {
                $i++;
                $block->id = $blockId;
                $block->data['orderBy'] = $i;
                $block->update($block->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;

        } else {

            /** фильтровать контента */
            $block->filter = array_filter([
                'query'     => $this->query,
                'status'    => $this->filter['status'] ?? '',
                'section'   => $this->filter['section'] ?? '',
            ]);

            /** получение всего контента */
            $dealers = collect($block->all($this->limit, $this->page))->map(function ($item) use ($SECTIONS) {
                $item['statusName']  = lang('general:statuses:' . $item['status']);
                $item['city']                  = GeoCities::getCityName($item['cityId']);
                return $item;
            })->all();

            /** pagination */
            $block->total();
            $pages = getPageNums($block->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalBlocks', $block->total);
            $this->smarty->assign('dealers', $dealers);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('sections', $sections);
            $this->smarty->assign('page', $this->page);

        }

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }



        /** Права доступа к данному шаблону */
        if ($this->permissions('dealers')) {
            return $this->smarty->fetch('views/contents/dealers.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }


}