<?php

namespace Mnv\Admin\Controllers;

use Mnv\Core\AdminMnv;
use Mnv\Models\UserGroups;

/**
 * Class DocumentDatabaseAdmin
 * @package Mnv\Admin\Controllers
 */
class DocumentDatabaseAdmin extends AdminMnv
{

    public function fetch()
    {
        $this->smarty->assign('activeItem', 'database');
        $this->smarty->assign('title', 'Работа с базой данных');


        try {
            if ($this->manager['userType'] == UserGroups::DEVELOPER) {
                return $this->smarty->fetch('views/documents/database.tpl');
            }

            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');

        } catch (\SmartyException | \Exception $e) {
            return $e->getMessage();
        }
    }

}