<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Countries;
use Mnv\Models\GeoCities;
use Mnv\Models\GeoDistricts;

/**
 * Class GeoDistrictAdmin
 * @package Mnv\Admin\Controllers
 */
class GeoDistrictAdmin extends AdminMnv
{
    public function fetch()
    {

        $country = new GeoDistricts($this->request);

        $this->smarty->assign('activeItem', 'districts');
        $this->smarty->assign('title', 'Район');
        /** statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));
        $this->smarty->assign('countries', GeoCities::getSelectCities());

        if ($this->action == 'add' || $this->action == 'edit') {

            $country->edit()->gettingInfoAboutUsers();
        }
        /** сохранение данных */
        elseif ($this->action == 'save' || $this->action == 'apply') {

            if (empty($country->data['name'])) $this->errors['name'] = true;
            if (empty($country->data['cityId'])) $this->errors['cityId'] = true;

            if (empty($this->errors)) {
                if ($country->prepare($country->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $country->edit()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action === 'save') {
                redirect($this->buildQueryString("districts", ['page' => $this->page]));
            }
        }

        $this->smarty->assign('district', $country->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions('districts')) {
            return $this->smarty->fetch('views/geo/geo.district.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}


