<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\Subscriber;

/**
 * Class SubscribersAdmin
 * @package Mnv\Admin\Controllers
 */
class SubscribersAdmin extends AdminMnv
{

    public function fetch()
    {
        $subscribersUser = new Subscriber($this->request);

        /** Заголовок, название подключаемого шаблона */
        $this->smarty->assign('activeItem','subscribers');
        $this->smarty->assign('title', lang('users:title'));

        /** удаление */
        if ($this->action === 'remove') {
            try {
                $subscribersUser->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // lang('users:messages:1')
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $subscribersUser->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /* получение всех менеджеров с картинками */
        $users = collect($subscribersUser->all( $this->limit, $this->page))->map(function ($item) {
            $item['registered'] = adjustTime($item['registered'], false, 'd.m.Y');

            return $item;
        })->all();

        /* получение кол-во менеджеров */
        $subscribersUser->total();
        $pages = getPageNums($subscribersUser->total, $this->page, $this->limit, 0, 4, 4, 0);


        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('users', $users);
        $this->smarty->assign('page', $this->page);


        /** Права доступа к данному шаблону */
        if ($this->permissions('subscribers')) {
            return $this->smarty->fetch('views/users/subscribers.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}




