{strip}
<div class="collapse {if $enable eq 1}show{/if}" id="gallery-card">
    <div class="card border shadow-sm">
        <div class="card-header d-flex flex-wrap">
            <h6 class="mb-0">{general:card:imageLibrary}</h6>
            <div class="d-inline-flex ms-auto">
                <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
            </div>
        </div>
        <div class="collapse show">
            <div class="card-body">
                <div class="row gallery gallery-product gallery-sortable mt-2 sortable" id="fileList">
                    {if !empty($galleries)}
                        {foreach item=file from=$galleries}
                            <figure class="gallery-item mb-0" id="item-{$file.imageId}" data-id="{$file.imageId}">
                                <div class="move_zone image">
                                    <img src="{$file.medium}" alt="{$file.title|default:''}"/>
                                    <ul class="gallery-item-controls">
                                        <li><span>{$file.orderBy}</span></li>
                                        <li>
                                            <span class="edit_image" id="edit_image_{$file.imageId}"
                                                  data-title="{$file.title}"
                                                  data-alias="{$file.alias}"
                                                  data-description="{$file.description}"
                                                  data-link="{$file.link}"
                                                  data-position="{$file.position}"
                                                  onclick="editPictureInfo({$file.imageId}, 'Добавить описание к картинке', '{$module}');"><i class="ph-note-pencil"></i></span>
                                        </li>
                                        <li>
                                            <span onclick="removeFile({$file.imageId}, '{$module}');"><i class="ph-trash"></i></span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="meta" id="meta_image_{$file.imageId}">
                                    <span id="im_title" class="fs-sm fw-normal fw-semibold">{$file.title}</span>
                                    <span id="im_alias" class="fs-sm fw-normal">{$file.alias}</span>
                                    <span id="im_description" class="fs-sm fw-normal">{$file.description nofilter}</span>
                                    <span id="im_link" class="fs-sm fw-normal">{$file.link}</span>
                                    <span id="im_position" class="badge bg-primary text-white fs-sm fw-light">{$file.position}</span>
                                </div>
                            </figure>
                        {/foreach}
                    {/if}
                </div>
            </div>

            <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
                <button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="gallery" data-path="/" data-action="read_more"><i class="ph-image me-2"></i> {general:uploadFiles} </button>
{*                <button type="button" class="btn btn-sm btn-primary btn-sorting collapse" data-action="sortPictures" data-module="article"><i class="ph-check me-2"></i> {general:apply}</button>*}
            </div>
        </div>
    </div>
</div>
{/strip}