{literal}
<script>

	// конфигурация
	const maxFiles = 20
	window.locales = {
		en: window.en, // предполагается, что `en-en.js` экспортирует объект как `window.en`
		ru: window.ru,  // предполагается, что `ru-ru.js` экспортирует объект как `window.ru`
		uz: window.uz  // предполагается, что `uz-uz.js` экспортирует объект как `window.uz`
	};

	// генерация UUID
	function generateUUID() {

		if (crypto && crypto.randomUUID) {
			return crypto.randomUUID();
		} else {
			return ([1e7] + -1e3 + -4e3 + -8e3 + -1e11)
				.replace(/[018]/g, (c) =>
					(c ^ (crypto.getRandomValues(new Uint8Array(1))[0] & (15 >> (c / 4)))).toString(16)
				);
		}
	}

	const inputElement = document.querySelector('input.filepond');

	// Пример использования локализаций в другом JS файле
	const currentLocale = window.locales.{/literal}{$config.website_language}{literal} ?? window.locales.en;

	FilePond.setOptions(currentLocale)
	FilePond.registerPlugin(
		FilePondPluginImagePreview,
        FilePondPluginImageExifOrientation,
        FilePondPluginFileValidateSize,
        FilePondPluginImageEdit,
        FilePondPluginFileValidateType,
        FilePondPluginMediaPreview
    );


	const pond = FilePond.create(inputElement, {
		name: 'file',
		maxFiles: maxFiles,
		maxFileSize: '{/literal}{$post_max_size|intval}{literal}MB',
		required: true,
		credits: false,
		allowMultiple: true,
		allowBrowse: true,

		allowImagePreview: true,
		allowImageFilter: true,
		imagePreviewHeight: 150,

		allowVideoPreview: true,
		allowAudioPreview: true,
		mediaPreviewHeight: 150,
		mediaPreviewAutoplay: false,
		mediaPreviewThumbnail: false,

		allowFileTypeValidation: true,
		allowRevert: true,
		acceptedFileTypes: null,
		loadingIndicatorPosition: 'right',
		panelAspectRatio: null,
		panelLayout: 'compact',
		placeholder: null,
		maxSize: null,
		minSize: null,
		removeUploadedFileButtonPosition: 'left',
		shouldAppendFiles: false,
		shouldOrientImageFromExif: true,
		shouldTransformImage: false,
		uploadButtonPosition: 'right',
		uploadProgressIndicatorPosition: 'right',
		server: {
			process: (fieldName, file, metadata, load, error, progress, abort, transfer, options) => {
				const uuid = generateUUID();
				const path = localStorage.getItem('path');
				const formData = new FormData();

				formData.append(fieldName, file, file.name);
				formData.append('uuid', uuid);
				formData.append('action', 'upload');
				formData.append('path', path);

				const request = new XMLHttpRequest();
				request.open('POST', '/admin/uploads');

				request.upload.onprogress = (e) => {
					progress(e.lengthComputable, e.loaded, e.total);
				};

				request.onload = async () => {
					if (request.status >= 200 && request.status < 300) {
						load(request.responseText);

						await fetchDataToHTML();
					} else {
						error('Upload failed');
					}
				};

				request.onerror = () => error('Network error');
				request.send(formData);

				return {
					abort: () => {
						request.abort();
						abort();
					},
				};
			},
			revert: async (uniqueFileId, load, error) => {
				try {
					const fileId = JSON.parse(uniqueFileId).fileId;
					const response = await fetch('/admin/uploads?action=remove', {
						method: 'DELETE',
						headers: { 'Content-Type': 'application/json' },
						body: JSON.stringify({ fileIds: [fileId] })
					});

					if (!response.ok) {
						throw new Error('Failed to remove file');
					}
					load();
					await fetchDataToHTML();
				} catch (err) {
					error('Failed to remove the file: ' + err.message);
				}
			},

			load: (source, load, error, progress, abort, headers) => {
				const xhr = new XMLHttpRequest();
				xhr.open('GET', source, true);

				xhr.onload = () => {
					if (xhr.status >= 200 && xhr.status < 300) {
						const file = new Blob([xhr.response], { type: xhr.getResponseHeader('Content-Type') });
						progress(true, xhr.response.length, xhr.response.length);
						load(file);
					} else {
						error('Failed to load file');
					}
				};

				xhr.onerror = () => error('Network error');
				xhr.onprogress = (e) => e.lengthComputable && progress(false, e.loaded, e.total);
				headers(xhr.getAllResponseHeaders());
				xhr.send();

				return {
					abort: () => {
						xhr.abort();
						abort();
					},
				};
			},

			fetch: (url, load, error, progress, abort, headers) => {
				const controller = new AbortController();

				fetch(url, { signal: controller.signal })
					.then(response => {
						if (!response.ok) {
							throw new Error('Network response was not ok');
						}
						headers(response.headers);
						return response.blob();
					}).then(blob => load(blob))
					.catch(err => error('Failed to fetch file: ' + err.message));

				return {
					abort: () => controller.abort(),
				};
			},

			restore: (uniqueFileId, load, error, progress, abort, headers) => {
				const controller = new AbortController();
				const url = `/admin/uploads?action=&fileId=${JSON.parse(uniqueFileId).fileId}`;

				fetch(url, { signal: controller.signal })
					.then(response => {
						if (!response.ok) {
							throw new Error('Network response was not ok');
						}
						headers(response.headers);
						return response.blob();
					})
					.then(blob => load(blob))
					.catch(err => error('Failed to restore file: ' + err.message));

				return {
					abort: () => controller.abort(),
				};
			},

			remove: (source, load, error) => {
				const fileId = JSON.parse(source).fileId;

				fetch('/admin/uploads?action=remove', {
					method: 'DELETE',
					headers: { 'Content-Type': 'application/json' },
					body: JSON.stringify({ fileIds: [fileId] })
				}).then(async response => {
                    if (!response.ok) {
						throw new Error('Failed to remove file');
                    }
                    load();
                    await fetchDataToHTML();
                }).catch(err => error('Failed to remove file: ' + err.message));
			}
		}
	});



	// ajax
	async function fetchDataToHTML() {
		const file_list = document.getElementById('file_list')

		let query = localStorage.getItem('query'),
			path = localStorage.getItem('path'),
			type = localStorage.getItem('mime'),
			filters = localStorage.getItem('filter'),
			page = localStorage.getItem('page');

		await fetch("index.php?mod=uploads&action=load", {
			method: 'POST',
			headers: {'Content-Type': 'application/json'},
			body: JSON.stringify({
				query: query,
				path: path,
				type: type,
				filters: filters
			})
		}).then(response => response.json()).then(data => {
			file_list.innerHTML = data.items;

		}).catch(error => console.error(error));

		// }).then(response => response.json()).then(data => {
		// 	if (data.items.dirs) {
		// 		data.items.dirs.forEach(item => directoryToHTML(data.path, item))
		// 	}
		// 	if (data.items.files) {
		// 		data.items.files.forEach(item => fileToHTML(data.path, item))
		// 	}
		// 	if (page == data.pagination.totalPages) {
		// 		modal_block_show = true;
		// 	}
		// })
	}

</script>
{/literal}


x-data="fileUploadFormComponent({
acceptedFileTypes: null,
imageEditorEmptyFillColor: null,
imageEditorMode: 1,
imageEditorViewportHeight: null,
imageEditorViewportWidth: null,
deleteUploadedFileUsing: async (fileKey) => {
return await $wire.deleteUploadedFile('data.media', fileKey)
},
getUploadedFilesUsing: async () => {
return await $wire.getFormUploadedFiles('data.media')
},
hasImageEditor: false,
hasCircleCropper: false,
canEditSvgs: true,
isSvgEditingConfirmed: false,
confirmSvgEditingMessage: 'Editing SVG files is not recommended as it can result in quality loss when scaling.\\n Are you sure you want to continue?',
disabledSvgEditingMessage: 'Editing SVG files is disabled as it can result in quality loss when scaling.',
imageCropAspectRatio: null,
imagePreviewHeight: null,
imageResizeMode: null,
imageResizeTargetHeight: null,
imageResizeTargetWidth: null,
imageResizeUpscale: true,
isAvatar: false,
isDeletable: true,
isDisabled: false,
isDownloadable: false,
isMultiple: true,
isOpenable: false,
isPreviewable: true,
isReorderable: false,
itemPanelAspectRatio: null,
loadingIndicatorPosition: 'right',
locale: 'en',
panelAspectRatio: null,
panelLayout: 'compact',
placeholder: null,
maxFiles: 5,
maxSize: null,
minSize: null,
removeUploadedFileUsing: async (fileKey) => {
return await $wire.removeFormUploadedFile('data.media', fileKey)
},
removeUploadedFileButtonPosition: 'left',
reorderUploadedFilesUsing: async (files) => {
return await $wire.reorderFormUploadedFiles('data.media', files)
},
shouldAppendFiles: false,
shouldOrientImageFromExif: true,
shouldTransformImage: false,
state: $wire.$entangle('data.media', false),
uploadButtonPosition: 'right',
uploadingMessage: 'Uploading file...',
uploadProgressIndicatorPosition: 'right',
uploadUsing: (fileKey, file, success, error, progress) => {
$wire.upload(
`data.media.${fileKey}`,
file,
() => {
success(fileKey)
},
error,
(progressEvent) => {
progress(true, progressEvent.detail.progress, 100)
},
)
},
})"