<!DOCTYPE html>
<html lang="{$config.website_language}" data-url="{$adminUrl}">
<head>
	<meta charset="{$config.charset}">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title>{if isset($title)}{$title} - {/if}{productName}</title>

	<link rel="apple-touch-icon" sizes="57x57" href="/admin/assets/favicon/apple-icon-57x57.png">
	<link rel="apple-touch-icon" sizes="60x60" href="/admin/assets/favicon/apple-icon-60x60.png">
	<link rel="apple-touch-icon" sizes="72x72" href="/admin/assets/favicon/apple-icon-72x72.png">
	<link rel="apple-touch-icon" sizes="76x76" href="/admin/assets/favicon/apple-icon-76x76.png">
	<link rel="apple-touch-icon" sizes="114x114" href="/admin/assets/favicon/apple-icon-114x114.png">
	<link rel="apple-touch-icon" sizes="120x120" href="/admin/assets/favicon/apple-icon-120x120.png">
	<link rel="apple-touch-icon" sizes="144x144" href="/admin/assets/favicon/apple-icon-144x144.png">
	<link rel="apple-touch-icon" sizes="152x152" href="/admin/assets/favicon/apple-icon-152x152.png">
	<link rel="apple-touch-icon" sizes="180x180" href="/admin/assets/favicon/apple-icon-180x180.png">
	<link rel="icon" type="image/png" sizes="192x192"  href="/admin/assets/favicon/android-icon-192x192.png">
	<link rel="icon" type="image/png" sizes="32x32" href="/admin/assets/favicon/favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="96x96" href="/admin/assets/favicon/favicon-96x96.png">
	<link rel="icon" type="image/png" sizes="16x16" href="/admin/assets/favicon/favicon-16x16.png">
	<link rel="manifest" href="/admin/assets/favicon/manifest.json">
	<meta name="msapplication-TileColor" content="#ffffff">
	<meta name="msapplication-TileImage" content="/admin/assets/favicon/ms-icon-144x144.png">
	<meta name="theme-color" content="#ffffff">

	{* styles *}
	{include file="common/styles.tpl"}
	{* /styles *}

	{* scripts *}
	{include file="common/scripts.tpl"}
	{* /scripts *}
</head>

<body>

{* Main navbar *}
<div class="navbar navbar-dark navbar-expand-lg navbar-static border-bottom border-bottom-white border-opacity-10">
	<div class="container-fluid">
		<div class="d-flex d-lg-none me-2">
			<button type="button" class="navbar-toggler sidebar-mobile-main-toggle rounded-pill"><i class="ph-list"></i></button>
		</div>

		<div class="navbar-brand flex-1 flex-lg-0">
			<a href="{$adminUrl}/main" class="d-inline-flex align-items-center">
				<img src="/admin/assets/images/logo_light.png" alt="{productName}">
			</a>
		</div>

		<ul class="nav flex-row">
{*			<li class="nav-item d-lg-none">*}
{*				<a href="#navbar_search" class="navbar-nav-link navbar-nav-link-icon rounded-pill" data-bs-toggle="collapse">*}
{*					<i class="ph-magnifying-glass"></i>*}
{*				</a>*}
{*			</li>*}

			<li class="nav-item nav-item-dropdown-lg dropdown">
				<a href="{$SITE_URL}" class="navbar-nav-link navbar-nav-link-icon rounded-pill" target="_blank">
					<i class="ph-browser me-2"></i>Перейти на сайт
				</a>
			</li>

			{if $config.comments_enabled && !empty($comments)}
				<li class="nav-item nav-item-dropdown-lg dropdown ms-lg-2">
					<a href="javascript:void('');" class="navbar-nav-link navbar-nav-link-icon rounded-pill" data-bs-toggle="dropdown" data-bs-auto-close="outside">
						<i class="ph-chats"></i>
						{if $totalPendingComments > 0}
						<span class="badge bg-yellow text-black position-absolute top-0 end-0 translate-middle-top zindex-1 rounded-pill mt-1 me-1">{$totalPendingComments}</span>
						{/if}
					</a>

					<div class="dropdown-menu wmin-lg-400 p-0">
						<div class="d-flex align-items-center p-3">
							<h6 class="mb-0">{comments:news}</h6>
							<div class="ms-auto">
	{*							<a href="#search_messages" class="collapsed text-body ms-2" data-bs-toggle="collapse">*}
	{*								<i class="ph-magnifying-glass"></i>*}
	{*							</a>*}
							</div>
						</div>

						{* нужно реализовать поиск *}
						<div class="collapse" id="search_messages">
							<div class="px-3 mb-2">
								<div class="form-control-feedback form-control-feedback-start">
									<input type="text" class="form-control" placeholder="Search messages">
									<div class="form-control-feedback-icon">
										<i class="ph-magnifying-glass"></i>
									</div>
								</div>
							</div>
						</div>

						<div class="dropdown-menu-scrollable pb-2">
							{foreach item=pendingComment from=$pendingComments name=pendingComments}
							<a href="{$adminUrl}/comment?action=edit&id={$pendingComment.commentId}" class="dropdown-item align-items-start text-wrap py-2">
								<div class="flex-1">
									<span class="fw-semibold"> {$pendingComment.authorName|truncate:20}</span>
									<span class="text-muted float-end fs-sm">{$pendingComment.addedOn}</span>
									<div class="text-muted">{$pendingComment.content|strip_tags|truncate:100}</div>
								</div>
							</a>
							{/foreach}
						</div>

						<div class="d-flex border-top py-2 px-3">
							<a href="{$adminUrl}/comments" class="text-body ms-auto">Смотреть все<i class="ph-arrow-circle-right ms-1"></i></a>
						</div>
					</div>
				</li>
			{/if}
		</ul>

		<div class="navbar-collapse justify-content-center flex-lg-1 order-2 order-lg-1 collapse" id="navbar_search">

		</div>

		<ul class="nav flex-row justify-content-end order-1 order-lg-2">
            {if $LANGUAGES|@count > 1}
				<li class="nav-item dropdown ms-xl-1">
                    {foreach item=navLang from=$LANGUAGES}
						{if ($SITE_LANG eq $navLang.codename) || (!$SITE_LANG && $navLang.isDefault)}
							<a href="" class="navbar-nav-link rounded dropdown-toggle" data-bs-toggle="dropdown">
								<img src="{$GLOBAL_URL}/admin/assets/lang/{$navLang.codename}.svg" class="w-24px h-24px rounded-pill me-2" alt="{$navLang.codename}">
								{$navLang.languageTransName|default:$navLang.languageName}
							</a>
						{/if}
					{/foreach}
					<div class="dropdown-menu dropdown-menu-end" data-bs-popper="static">
                        {foreach item=navLang from=$LANGUAGES}
							<a href="{$GLOBAL_URL}/admin/{if !$navLang.isDefault}{$navLang.codename}/{/if}{$smarty.const.REQUESTED_FILE}" class="dropdown-item
    						{if ($SITE_LANG eq $navLang.codename) || (!$SITE_LANG && $navLang.isDefault)}active{/if}">
								<img src="{$GLOBAL_URL}/admin/assets/lang/{$navLang.codename}.svg" class="w-24px h-24px rounded-pill me-2" alt="{$navLang.codename}">
                                {$navLang.languageTransName|default:$navLang.languageName}
							</a>
                        {/foreach}
					</div>
				</li>
            {/if}

{*			<li class="nav-item ms-lg-2">*}
{*				<a href="javascript:void('');" class="navbar-nav-link navbar-nav-link-icon rounded-pill" data-bs-toggle="offcanvas" data-bs-target="#notifications">*}
{*					<i class="ph-bell"></i>*}
{*					<span class="badge bg-yellow text-black position-absolute top-0 end-0 translate-middle-top zindex-1 rounded-pill mt-1 me-1">2</span>*}
{*				</a>*}
{*			</li>*}
            {if isset($adminManager)}
				<li class="nav-item nav-item-dropdown-lg dropdown ms-lg-2">
					<a href="javascript:void('');" class="navbar-nav-link align-items-center rounded-pill p-1" data-bs-toggle="dropdown">
						<div class="status-indicator-container">
							<img src="{if isset($adminManager.image)}{$adminManager.image.large}{else}/admin/assets/images/no_images.jpg{/if}" class="w-32px h-32px rounded-pill" alt="{$adminManager.fullName}">
							<span class="status-indicator bg-success"></span>
						</div>
						<span class="d-none d-lg-inline-block mx-lg-2">{$adminManager.fullName}</span>
					</a>

					<div class="dropdown-menu dropdown-menu-end">
						<div class="dropdown-header fs-sm ">Сайт</div>
						<a href="{$SITE_URL}" class="dropdown-item" target="_blank"><i class="ph-browser me-2"></i>Перейти на сайт</a>
						<div class="dropdown-divider"></div>
						<div class="d-flex">
							<label class="btn btn-teal theme-group-item form-check mx-1">
								<input type="radio" class="btn-check" name="main-theme" value="light" checked>
								<i class="ph-sun mx-2"></i>
							</label>

							<label class="btn btn-teal theme-group-item form-check">
								<input type="radio" class="btn-check" name="main-theme" value="dark">
								<i class="ph-moon mx-2"></i>
							</label>

							<label class="btn btn-teal theme-group-item form-check mx-1">
								<input type="radio" class="btn-check" name="main-theme" value="auto">
								<i class="ph-monitor mx-2"></i>
							</label>
						</div>

						<div class="dropdown-header fs-sm">Аккаунт</div>
						<a class="dropdown-item" href="{if $adminManager.userType eq $DEVELOPER}{$adminUrl}/developer?action=edit&id={$adminManager.userId}{else}{$adminUrl}/manager?action=edit&id={$adminManager.userId}{/if}"><i class="ph-gear me-2"></i>Ваш профиль</a>
						<a class="dropdown-item" href="{if $adminManager.userType eq $DEVELOPER}{$adminUrl}/developer?action=add{else}{$adminUrl}/manager?action=add{/if}"><i class="ph-user-circle me-2"></i>Добавить аккаунт</a>
	{*					<div class="dropdown-divider"></div>*}
						<a class="dropdown-item" href="{$adminUrl}/auth?action=logout"><i class="ph-sign-out me-2"></i> Выйти</a>
					</div>
				</li>
            {/if}
		</ul>
	</div>
</div>
{* /Main navbar *}

{* Page content *}
<div class="page-content">

	{* Main sidebar *}
	<div class="sidebar sidebar-dark sidebar-main sidebar-expand-lg {if isset($smarty.cookies.sidebar) AND $smarty.cookies.sidebar eq true}sidebar-main-resized{/if}">

		{* Sidebar content *}
		<div class="sidebar-content">

			{* Sidebar header *}
			<div class="sidebar-section">
				<div class="sidebar-section-body d-flex justify-content-center">
					<h5 class="sidebar-resize-hide flex-grow-1 my-auto">Навигация</h5>

					<div>
						<button type="button" class="btn btn-flat-white btn-icon btn-sm rounded-pill border-transparent sidebar-control sidebar-main-resize d-none d-lg-inline-flex">
							<i class="ph-arrows-left-right"></i>
						</button>
						<button type="button" class="btn btn-flat-white btn-icon btn-sm rounded-pill border-transparent sidebar-mobile-main-toggle d-lg-none">
							<i class="ph-x"></i>
						</button>
					</div>
				</div>
			</div>
			{* /Sidebar header *}

			{* Main navigation *}
			<div class="sidebar-section">
				<ul class="nav nav-sidebar" data-nav-type="accordion">
					<li class="nav-item">
						<a href="{$adminUrl}/main" class="nav-link {if isset($activeItem) && ($activeItem eq 'main')}active{/if}"><i class="ph-house"></i><span data-i18n="menu.dashboard">Dashboard</span></a>
					</li>

					<!-- Main -->
                    {if isset($adminManager)}
                        {foreach from=$menu item=itemMenu}{if isset($itemMenu.activeItems)}
							<li class="nav-item {if isset($itemMenu.children)}nav-item-submenu{/if} {foreach from=$itemMenu.activeItems item=active}{if isset($activeItem) && ($activeItem eq $active)}nav-item-expanded nav-item-open{/if}{/foreach}">
								{if isset($itemMenu.children)}
									<a href="javascript:void('');" class="nav-link">
										<i class="{$itemMenu.icon}"></i>
										<span data-i18n="menu.{$itemMenu.name}"> {$itemMenu.name}</span>
									</a>

									<ul class="nav-group-sub collapse {foreach from=$itemMenu.activeItems item=active}{if isset($activeItem) && ($activeItem eq $active)}show{/if}{/foreach}"
										data-submenu-title="{$itemMenu.name}">
										{foreach from=$itemMenu.children item=subItemMenu}
											<li class="nav-item">
												<a class="nav-link {if isset($activeItem) && ($activeItem eq $subItemMenu.fileName)}active{/if}"
												   href="{$adminUrl}/{$subItemMenu.fileName}">
													{if isset($subItemMenu.icon)}<i class="{$subItemMenu.icon}"></i>{/if}
													{$subItemMenu.name}
												</a>
											</li>
										{/foreach}
									</ul>
								{else}
									<a href="{$adminUrl}/{$itemMenu.fileName}" class="nav-link {if isset($activeItem) && ($activeItem eq $itemMenu.fileName)}active{/if}">
										<i class="{$itemMenu.icon}"></i>
										<span data-i18n="menu.{$itemMenu.name}"> {$itemMenu.name}</span>
									</a>
								{/if}
							</li>
                        {/if} {/foreach}
                    {/if}
					<li class="nav-item">
						<a href="{$adminUrl}/about" class="nav-link {if isset($activeItem) && ($activeItem eq 'about')}active{/if}">
							<i class="ph-coffee"></i><span>О проекте</span>
						</a>
					</li>

{*					<li class="nav-item nav-item-submenu {if isset($activeItem) && ($activeItem eq 'helper')}active{/if}">*}
{*						<a href="javascript:void('');" class="nav-link"><i class="ph-lifebuoy"></i><span>Написать в поддержку</span></a>*}
{*						<ul class="nav-group-sub collapse" style="">*}
{*							<li class="nav-item"><a href="widgets_content.html" class="nav-link">Контакты</a></li> *}{* сюда модалку посадить *}
{*							<li class="nav-item"><a href="widgets_stats.html" class="nav-link">Телеграм</a></li> *}{* сюда ссылку на телеграм бот *}
{*						</ul>*}
{*					</li>*}
				</ul>
			</div>
			{* /Main navigation *}

		</div>
		{* /sidebar content *}

	</div>
	{* /main sidebar *}

	{* Main content *}
	<div class="content-wrapper">
		{* Inner content *}
		<div class="content-inner">
            {if $content}
				{* content tpl *}
                {$content nofilter}
				{* /content tpl *}
            {else}
				{* Page header *}
				<div class="page-header page-header-light">
					<div class="page-header-content header-elements-md-inline">
						<div class="page-title d-flex">
							<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title|default:''}</span></h4>
							<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
						</div>

						<div class="header-elements d-none">
							<div class="d-flex justify-content-center">
								<a href="{$adminUrl}/overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
							</div>
						</div>
					</div>

					<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline"></div>
				</div>
				{* /Page header *}

				{* Content area *}
				<div class="content">
					<div class="row">
						<div class="col-lg-12 col-md-12 col-sm-12 mt-1">
							<div class="boxed boxed_warning">
								<div class="heading_box">
									<h1>Такого модуля не существует</h1>
								</div>
							</div>
						</div>
					</div>
				</div>
				{* /Content area *}
            {/if}
		</div>
		{* /inner content *}

		{* Footer *}

		{* сортировка перемещением в таблице *}
			<div class="navbar navbar-sm navbar-footer border-top sortable_footer_navbar collapse">
				<div class="col-12">
					<div class="d-flex justify-content-center">
						<button class="btn btn-sm btn-primary sortable_save_button me-2" type="button">{general:apply}</button>
						<button class="btn btn-sm btn-light sortable_cancel_button" type="button">{general:cancel}</button>
					</div>
				</div>
			</div>
		{* /сортировка перемещением в таблице *}

		{* действия с контентом при выборе checkboxes *}
			<div class="navbar navbar-sm navbar-footer border-top footer_navbar collapse">
				<div class="col-12">
					<ul class="nav nav-pills justify-content-center">
						<li class="nav-item">
							<div class="input-group">
								<select class="form-control select content_select_action" name="group_action" data-width="250">
									<option value="0">Выбрать действие...</option>
									<option value="status"> Изменить статус</option>
									<option value="remove">Удалить выбранное</option>
								</select>
								<button class="btn btn-sm btn-primary px-3 content_save_button" type="button">Применить</button>
							</div>
						</li>
					</ul>
				</div>
			</div>
        {* действия с контентом при выборе checkboxes *}

		{* footer *}
			{if $config.debugging}
				<div class="navbar navbar-sm navbar-footer border-top">
					<div class="container-fluid">
						<span>&copy; 2001 - {$smarty.now|date_format:"%Y"}. MNV by <a href="https://www.life-style.uz/" target="_blank">Life Style</a></span>

						<ul class="nav">
							<li class="nav-item">
								<a class="text-left">
									<i class="icon-meter-fast"></i>&nbsp; Использовано памяти : {$debug_memory} Мб ({$debug_memusage} Мб макс)<br>
									<i class="icon-history"></i>&nbsp; Время работы скрипта: {$debug_timer} мс
								</a>
							</li>
						</ul>
					</div>
				</div>
			{/if}
		{* /footer *}

	</div>
	{* /Main content *}

</div>
{* /Page content *}

</body>
</html>
