
<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-icon btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/banner?action=add"><i class="ph-plus"></i></a>
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/banners" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/banners"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<div class="content">

	<div class="row">
		<div class="col-md-12">
			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-togglable table-xs table-striped table-hover" id="banners">
						<thead>
						<tr>
							<th data-hide="ID" class="text-center" width="30">#</th>
							<th data-hide="image" class="text-center">{sliders:image}</th>
							<th data-toggle="true">Название</th>
							<th data-toggle="true">Раздел</th>
							<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if !empty($banners)}
							<tbody class="sortable">

                            {foreach item=banner from=$banners name=banners}
								<tr id="banner-{$banner.bannerId}" data-id="{$banner.bannerId}" class="{if $banner.status eq 'H'}table-warning{/if}">
									<td class="text-center text-nowrap"><i class="ph-dots-six text-muted"></i></td>
									<td class="text-center"><div class="preview preview-md"><img src="{$banner.image}" class="img-thumbnail w-80px"/></div></td>

									<td width="100%"><span  data-popup="popover-solid" data-trigger="hover" title="{$banner.title}" data-placement="top" >{$banner.title|strip_tags|truncate:100|escape}</span></td>
									<td class="text-nowrap">{foreach from=$banner.sections item=section}<span class="badge bg-warning">{$section}</span> {/foreach}</td>

									<td class="text-center">
										<div class="d-inline-flex">
											<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/banner?action=edit&id={$banner.bannerId}"><i class="ph-note-pencil me-2"></i></a>
											<div class="list-icons-item dropdown">
												<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

												<div class="dropdown-menu dropdown-menu-end">
													<a class="dropdown-item" href="{$adminUrl}/banner?action=edit&id={$banner.bannerId}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
													{include file="components/actions/dropdown-status.tpl" module="banners" id=$banner.bannerId status=$banner.status}
													{include file="components/actions/dropdown-delete.tpl" id=$banner.bannerId title="{$banner.title|escape|default:''}" module="banners" scope=parent}
												</div>
											</div>
										</div>
									</td>
								</tr>
                            {/foreach}
							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="6">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/banners" params="{$buildQueryString}"}
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function () {

        {if isset($errors.slider_not_found)} new Noty({ text: 'Баннер с таким ID не найден', type: 'error' }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: 'Баннер сохранен', type: 'success' }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Баннер не сохранен', type: 'error' }).show();{/if}

    });

    $(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('.sortable tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/banners?action=reorder", { ids : ids }, function( data ) {
            $('.sortable_footer_navbar').removeClass('show');
            // location.reload();
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        location.reload();
    })

</script>


