<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
{/capture}

{capture name="breadcrumb"}
	<a href="{$generate_url}" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url=$generate_url}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


<!-- Content area -->
<div class="content">

    <div class="row">
    	<div class="col-md-12">
            
            <div class="card">
	            <div class="">
	                <table class="table table-togglable table-striped table-hover" id="bcolors">
                    <thead>
                        <tr>
	                        <th data-hide="ID" class="text-center" width="30">#</th>
                            <th data-toggle="true">Название цвета</th>
	                        <th data-toggle="true">Код цвета</th>
	                        <th data-toggle="true">Модель</th>
                            <th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
                        </tr>
                    </thead>
                    {if isset($colors)}
	                    <tbody class="sortable">

	                        {foreach item=color from=$colors name=colors}
	                        <tr id="bcolor-{$color.colorId}" data-id="{$color.colorId}" class="{if $color.status eq 'H'}table-warning{/if}">
		                        <td class="text-center text-nowrap"><i class="ph-dots-six text-muted"></i></td>

	                            <td><b>{$color.colorName|truncate:75}</b></td>
		                        <td><b> <span class="badge badge-primary d-block" style="background-color: {$color.colorCode}">{$color.colorCode}</span></b></td>
		                        <td>{foreach from=$color.equipments item=equipment}<span class="badge bg-secondary">{$equipment}</span> {/foreach}</td>

	                            <td class="text-center">
		                            <div class="d-inline-flex">
			                            <a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit&id={$color.colorId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
			                            <div class="dropdown">
				                            <a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
				                            <div class="dropdown-menu dropdown-menu-end">
	                                            <a class="dropdown-item" href="{$generate_url|substr:0:-1}?action=edit&id={$color.colorId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
					                            <button class="dropdown-item ajax_action" data-module="bcolors" data-action="status" data-id="{$color.colorId}"><i class="{if $color.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
	                                            <div class="dropdown-divider"></div>
	                                            <button class="dropdown-item text-danger" onclick="remove({$color.colorId}, '{$color.colorName nofilter}', 'bcolors');"><i class="ph-trash me-2"></i>  {general:delete}</button>
	                                        </div>
	                                    </div>
	                                </div>
	                            </td>
	                        </tr>
	                        {/foreach}

	                    </tbody>
                    {else}
                        <tbody><tr class="odd"><td class="data none" colspan="8" align="center">- {general:none} -</td></tr></tbody>
                    {/if}
                </table>
	            </div>
                {include file="module/pagination.tpl" url="{$generate_url}" params="{$buildQueryString}"}
            </div>
    	</div>
    
    </div>
</div>

	<script>

    $(document).ready(function () {

        {if isset($messages.saved)} new Noty({ text: 'Цвет сохранен', type: 'success', timeout: 1500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Цвет не сохранен', type: 'error', timeout: 2500 }).show(); {/if}
    });

    function deleteError(){
        new Noty({ text: 'ошибка при удаление цвета', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function deleteSuccess(id){
        new Noty({ text: 'Цвет не удален, обновите страницу и повторите удаление', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'color');
    }

    function statusError(){
        new Noty({ text: 'ошибка при изменение статуса цвета', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }


    $(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('.sortable tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/bcolors?action=reorder", { ids : ids }, function( data ) {
            $('.sortable_footer_navbar').removeClass('show');
            // location.reload();
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        location.reload();
    })


</script>



