
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/blockmodel?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>

	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/model?action=edit&id={$model_id}" class="breadcrumb-item">Модель</a>
		<a href="{$adminUrl}/blockmodels" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/blocks"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<!-- Content area -->
	<div class="content">

		<div class="row">
			<div class="col-md-12">
				<div class="card border shadow-sm">
					<form action="{$generate_url}" method="post">
						<div class="card-header bg-light py-2 d-sm-flex align-items-sm-center">
							<div class="mb-0">
								<div class="input-group">
									<input type="text" class="form-control" name="query" value="{if isset($query)}{$query}{/if}" autocomplete="off" placeholder="{products:general:searchByName}">
									<button type="submit" class="btn btn-sm btn-primary"><i class="icon-search4 me-2"></i>{general:search}</button>
								</div>
							</div>

							<div class="ms-sm-auto">
								<ul class="list-inline list-inline-condensed mb-0">
									<li class="list-inline-item">
										<div class="input-group">
                                            {if isset($models) && !empty($models)}
                                                {html_options options=$models selected=$model_id|default:'' name="model_id" class="form-control select" onchange="this.form.submit()" data-width="250"}
                                            {/if}

                                            {if isset($statuses) && !empty($statuses)}
                                                {html_options options=$statuses selected=$sts|default:'' name="sts" class="form-control select" onchange="this.form.submit()" data-width="160"}
                                            {/if}

										</div>
									</li>
								</ul>
							</div>
						</div>
					</form>
				</div>

				<div class="card border shadow-sm">
					<div class="">
						<table class="table table-togglable table-striped table-hover" id="blockmodels">
							<thead>
							<tr>
								<th data-hide="ID" class="text-center" width="30">#</th>
								<th data-toggle="true">{general:table:name}</th>
								<th data-hide="phone" class="text-left">Модель</th>
								<th data-hide="phone" class="text-left">Расположение</th>
								<th data-hide="phone" class="text-left">Тип</th>
								<th data-hide="phone" class="text-center">{general:table:status}</th>
								<th class="text-center text-muted" width="40"><i class="ph-check"></i></th>
							</tr>
							</thead>
	                        {if $blocks}
								<tbody class="sortable">

	                            {foreach item=block from=$blocks name=blocks}
									<tr id="blockmodel-{$block.blockId}" data-id="{$block.blockId}" class="{if $block.status eq 'H'}table-warning{/if}">
										<td class="text-center text-nowrap"><i class="ph-dots-six text-muted" data-bs-popup="tooltip" title="Переместить" data-bs-placement="auto"></i></td>
										<td><b>{$block.title|truncate:75}</b></td>
										<td class="text-left"><span class="badge bg-secondary">{$block.model}</span></td>
										<td class="text-left"><span class="badge bg-warning">{$block.position}</span></td>
										<td class="text-left"><span class="badge bg-{if $block.type eq 'E'}secondary{elseif $block.type eq 'I'}info{/if}">{$block.typeName}</span></td>
										<td class="text-center" id="status-{$block.blockId}">{$block.statusName nofilter}</td>
										<td class="text-center">
											<div class="d-inline-flex">
												<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/blockmodel?action=edit&id={$block.blockId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
												<div class="list-icons-item dropdown">
													<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
													<div class="dropdown-menu dropdown-menu-end">
														<a class="dropdown-item" href="{$adminUrl}/blockmodel?action=edit&id={$block.blockId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
														<button class="dropdown-item ajax_action" data-module="blocks" data-action="status" data-id="{$block.blockId}"><i class="{if $block.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
														<div class="dropdown-divider"></div>
														<button class="dropdown-item text-danger" onclick="remove({$block.blockId}, '{$block.title|escape}', 'blockmodels');"><i class="ph-trash me-2"></i> {general:delete}</button>
													</div>
												</div>
											</div>
										</td>
									</tr>
	                            {/foreach}

								</tbody>
	                        {else}
								<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
	                        {/if}
						</table>
					</div>

	                {include file="module/pagination.tpl" url="{$adminUrl}/blockmodels" params="{$buildQueryString}"}
				</div>
			</div>

		</div>
	</div>

	<script>

    $(document).ready(function () {
      
        {if isset($messages.saved)} new Noty({ text: 'Блок сохранен', type: 'success', timeout: 1500 }).show(); {/if}
        
        {if isset($errors.access_denied)} new Noty({ text: '{articles:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)}   new Noty({ text: 'Блок не сохранен', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: 'Блок не найден', type: 'error', timeout: 2500 }).show(); {/if}

    });


    function notFound(){
        new Noty({ text: 'Блок не найден', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }
    function statusError(){
        new Noty({ text: 'ошибка при изменение статуса', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }


    $(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('.sortable tr').each(function () {
            ids.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/blockmodels?action=reorder", { ids : ids }, function() {
            $('.sortable_footer_navbar').removeClass('show');
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        location.reload();
    })
</script>


