<form class="form-validation" method="post" novalidate>
	<!-- Page header -->
	{capture name="buttons"}
		<button class="btn btn-sm btn-primary mx-2" type="submit" name="action" value="apply"><i class="ph-check me-2"></i> {general:apply}</button>
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/statuses" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
		<div class="row">
			<div class="col-md-12">
				<div class="card border shadow-sm">
					<div class="">
						<table class="table table-togglable table-xs table-striped table-hover table_deals" id="deals">
							<thead>
							<tr>
								<th data-toggle="true">Название варианта оптаты</th>
								<th data-toggle="true">Ключ варианта</th>
								<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
							</tr>
							</thead>
							<tbody class="sortable">
	                            {assign var=deal_row value=0}
	                            {if !empty($deals)}
		                            {foreach item=deal from=$deals name=deals}
										<tr id="deal-{$deal_row}">
											<td width="50%"><input class="form-control" type="text" name="deal[{$deal_row}][name]" value="{$deal.name|default:''}" placeholder="Название варианта" required/></td>
											<td width="50%"><input class="form-control" type="text" name="deal[{$deal_row}][fileName]" value="{$deal.fileName|default:''}" placeholder="Ключ варианта" required/></td>
											<td class="text-left">
												<input class="form-control" type="hidden" name="deal[{$deal_row}][id]" value="{$deal.id}" />
												<button type="button" class="btn btn-link text-danger p-0" onclick="confirm('Данное действие необратимо. Вы уверены?') ? $('#deal-{$deal_row}').remove() : false;"><i class="ph-trash"></i></button>
											</td>
										</tr>
		                                {assign var=deal_row value=$deal_row+1}
		                            {/foreach}
	                            {else}
									<tr class="tr_empty"><td class="text-center" colspan="3">- {general:none} -</td></tr>
		                        {/if}
							</tbody>
						</table>
					</div>
					<div class="card-footer text-right">
						<button type="button" class="btn btn-outline-primary" onclick="addStatus();">Добавить вариант</button>
					</div>
				</div>

			</div>

			<div class="col-md-12 text-center">
                {$smarty.capture.buttons nofilter}
			</div>
		</div>
	</div>
</form>


<script>
	$(document).ready(function () {

		{if isset($messages.saved)} new Noty({ text: 'Варианты оптаты сохранены', type: 'success', timeout: 1500 }).show(); {/if}
		{if isset($errors.message)} new Noty({ text: '{$errors.message}', type: 'error', timeout: 2500 }).show(); {/if}

	});

    var deal_row = {$deal_row};

    function addStatus() {
        html  = '<tr id="deal-' + deal_row + '">';
        html += '    <td><input class="form-control" type="text" name="deal[' + deal_row + '][name]" placeholder="Название варианта" required/></td>';
        html += '    <td><input class="form-control" type="text" name="deal[' + deal_row + '][fileName]" placeholder="Ключ статуса" required/></td>';
        html += '    <td><input class="form-control" type="hidden" name="deal[' + deal_row + '][id]" />' +
            			'<button type="button" class="btn btn-link text-danger p-0" onclick="confirm(\'Данное действие необратимо. Вы уверены?\') ? $(\'#deal-' + deal_row + '\').remove() : false;"><i class="ph-trash"></i></button>' +
            		'</td>';
        html += '</tr>';

        $('.table_deals tbody').append(html);
		if (deal_row == 0) {
			document.querySelectorAll('.table_deals tbody tr.tr_empty').forEach(function(row) {
				row.remove();
			});
		}

		deal_row++;
    }

</script>






