
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/engine?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>

	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/engines" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/engines"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<!-- Content area -->
	<div class="content">

		<div class="row">
			<div class="col-md-12">
				<div class="card border shadow-sm">
					<div class="">
						<table class="table table-togglable table-striped table-hover" id="engines">
							<thead>
							<tr>
								<th data-hide="ID" class="text-center" width="30">#</th>
								<th data-toggle="true">{general:table:name}</th>
								<th data-toggle="true">code</th>
								<th data-hide="phone" class="text-center">{general:table:status}</th>
								<th class="text-center text-muted" width="40"><i class="ph-check"></i></th>
							</tr>
							</thead>
	                        {if $engines}
								<tbody class="sortable">

	                            {foreach item=engine from=$engines name=engines}
									<tr id="engine-{$engine.engineId}" data-id="{$engine.engineId}" class="{if $engine.status eq 'H'}table-warning{/if}">
										<td class="text-center text-nowrap"><i class="ph-dots-six text-muted" data-bs-popup="tooltip" title="Переместить" data-bs-placement="auto"></i></td>
										<td><b>{$engine.name|truncate:75}</b></td>
										<td><b>{$engine.code}</b></td>
										<td class="text-center" id="status-{$engine.engineId}">{$engine.statusName nofilter}</td>
										<td class="text-center">
											<div class="d-inline-flex">
												<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/engine?action=edit&id={$engine.engineId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
												<div class="list-icons-item dropdown">
													<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
													<div class="dropdown-menu dropdown-menu-end">
														<a class="dropdown-item" href="{$adminUrl}/engine?action=edit&id={$engine.engineId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
														<button class="dropdown-item ajax_action" data-module="engines" data-action="status" data-id="{$engine.engineId}"><i class="{if $engine.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
														<div class="dropdown-divider"></div>
														<button class="dropdown-item text-danger" onclick="remove({$engine.engineId}, '{$engine.name|escape}', 'engines');"><i class="ph-trash me-2"></i> {general:delete}</button>
													</div>
												</div>
											</div>
										</td>
									</tr>
	                            {/foreach}

								</tbody>
	                        {else}
								<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
	                        {/if}
						</table>
					</div>

	                {include file="module/pagination.tpl" url="{$adminUrl}/engines" params="{$buildQueryString}"}
				</div>
			</div>

		</div>
	</div>

	<script>

    $(document).ready(function () {
      
        {if isset($messages.saved)} new Noty({ text: 'Блок сохранен', type: 'success', timeout: 1500 }).show(); {/if}
        
        {if isset($errors.access_denied)} new Noty({ text: '{articles:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)}   new Noty({ text: 'Блок не сохранен', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: 'Блок не найден', type: 'error', timeout: 2500 }).show(); {/if}

    });


    function notFound(){
        new Noty({ text: 'Блок не найден', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }
    function statusError(){
        new Noty({ text: 'ошибка при изменение статуса', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }


    $(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('.sortable tr').each(function () {
            ids.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/engines?action=reorder", { ids : ids }, function() {
            $('.sortable_footer_navbar').removeClass('show');
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        location.reload();
    })
</script>


