<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/gears?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/gears" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<div class="content">

		<div class="row">
			<div class="col-md-8">

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">

								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.name)}text-danger{/if}">{general:title}</label>
										<input type="text" class="form-control" id="name" autocomplete="off" name="gear[name]" value="{$gear.name|default:''}">
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group form-group-float">
										<label class="form-group-float-label"> Code</label>
										<input type="text" class="form-control" id="code" autocomplete="off" name="gear[code]" value="{$gear.code|default:""}">
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

			</div>

			<div class="col-md-4">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="gear[status]" array=$statuses selected=$gear.status|default:'V'  class="form-group mb-3"}
                            {* /field status *}
						</div>
                        {if isset($gear.addedOn) && isset($gear.modifiedOn)}
						<div class="card-footer hstack gap-3 justify-content-between">
							<div class="text-muted">
								<ul class="list list-unstyled mb-0 fs-sm">
                                    <li>{general:created}</li>
                                    <li>{general:modified}</li>
								</ul>
							</div>
							<div class="hstack gap-1">
								<ul class="list list-unstyled mb-0 fs-sm">
                                    <li>{$gear.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$gear.addedBy.loginName|default:"{general:unknownUser}"})</li>
                                    <li>{$gear.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$gear.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
								</ul>
							</div>
						</div>
                        {/if}
					</div>
				</div>

                {* image preview *}
{*                {include file="components/image-preview.tpl"*}
{*                image="{if isset($block.image)}{$block.image.original}{/if}"*}
{*                id="{if isset($block.image)}{$block.image.imageId}{/if}"*}
{*                module='block'}*}
                {* /image preview *}

			</div>

			<div class="col-md-12 main main_buttons text-center">
                {if isset($gear.gearId)}<input type="hidden" class="form-control" id="id" name="id" value="{$gear.gearId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>

	</div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>

    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: 'Привод сохранен', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.title)} new Noty({ text: '{articles:errors:1}', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.sectionId)} new Noty({ text: '{articles:errors:2}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Привод не сохранен', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: 'Нет ни одного раздела', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.position)} new Noty({ text: 'Необходимо выбрать номер позиции', type: 'error', timeout: 2500 }).show(); ;{/if}

    });

    function notFound() {
        new Noty({ text: '{articles:errors:6}', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }

    function successSortImageMessage() {
        new Noty({ text: 'Порядковый номер изменен', type: 'success', timeout: 1500 }).show();
    }



</script>
