
<!-- Page header -->
{capture name="buttons"}
    {if !empty($sections)}
		<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
    {/if}
{/capture}

{capture name="breadcrumb"}
	<a href="{$generate_url}" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url=$generate_url}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<!-- Content area -->
<div class="content">

	<div class="row">
		<div class="col-md-12">
            <div class="card border shadow-sm">
                {include file="components/selectors.tpl" isFilter=true url=$generate_url filterDate=true}
            </div>
			<div class="card border shadow-sm">
                {include file="views/cars/components/tab.tpl"}
				<div class="">
					<table class="table table-xs table-togglable table-striped table-hover" id="{$module}">
						<thead>
						<tr>
							<th class="text-center" width="120">{general:table:image}</th>
							<th class="text-start">Название модели</th>
							<th class="text-start">{general:table:section}</th>
							<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if !empty($models)}
							<tbody>
                            {foreach item=model from=$models name=models}
								<tr id="{$module|substr:0:-1}-{$model.modelId}" data-id="{$model.modelId}" class="{if $model.status eq 'H'}table-warning{/if}">
									<td class="text-center"><img src="{$model.image}" class="img-preview" alt="{$model.title}"/></td>
									<td class="text-start"><b title="{$model.title}">{$model.title|truncate:75}</b></td>
									<td class="text-start"><span class="badge bg-secondary">{$model.section|truncate:25}</span></td>
									<td class="text-center">
										<div class="d-inline-flex">
											<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit&id={$model.modelId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
											<div class="dropdown">
												<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
												<div class="dropdown-menu dropdown-menu-end">
													<a class="dropdown-item" href="{$model.url}" target="_blank"><i class="ph-share me-2"></i> {general:view}</a>
													<a class="dropdown-item" href="{$generate_url|substr:0:-1}?action=edit&id={$model.modelId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
													<button class="dropdown-item ajax_action" data-module="{$module}" data-action="status" data-id="{$model.modelId}"><i class="{if $model.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
													<div class="dropdown-divider"></div>
													<button class="dropdown-item text-danger" onclick="remove({$model.modelId}, '{$model.title|escape}', '{$module}');"><i class="ph-trash me-2"></i> {general:delete}</button>
												</div>
											</div>
										</div>
									</td>
								</tr>
                            {/foreach}
							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$generate_url}" params="{$buildQueryString}"}
			</div>
		</div>

	</div>
</div>

<script>

    function notFound() {
        new Noty({ text: 'контент не найден или пустой ID', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }
    function approveError() {
        new Noty({ text: 'ошибка при одобрение контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function approveSuccess(id) {
        document.getElementById('status-' + id).innerHTML = '{general:statuses:V}';
        document.getElementById('article-approve-' + id).style.display = 'none';
        document.getElementById('article-status-' + id).innerHTML = '<i class="icon-eye"></i> {general:statuses:V}';
        new Noty({ text: 'Контент одобрен без модерации', layout: 'topRight', type: 'success', timeout: 1500 }).show();
    }

    $(document).ready(function () {

        {if isset($messages.saved)} new Noty({ text: '{articles:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.access_denied)} new Noty({ text: '{articles:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)}   new Noty({ text: '{articles:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{articles:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}

        {if isset($notice)} new Noty({ text: {$notice}, type: 'error', timeout: 2500 }).show(); {/if}

    });


    // выбрать все
    $(document).on("change", ".content_check_all", function () {
        if ($(this).is(":checked")) {
            $('.content_list_check').each(function () {
                if (!$(this).is(":checked")) $(this).trigger("click");
            });
            $('.footer_navbar').removeClass('collapse').addClass('fixed-bottom')
        } else {
            $('.content_list_check').each(function () {
                if ($(this).is(":checked")) $(this).trigger("click");
            });
            $('.footer_navbar').addClass('collapse').removeClass('fixed-bottom')
        }
    });

    // выбрать один
    $(document).on("change", ".content_list_check", function () {
        if ( $('input.content_list_check:checked').length > 0 ) {
            $('.footer_navbar').removeClass('collapse').addClass('fixed-bottom')

        } else {
            $('.footer_navbar').addClass('collapse').removeClass('fixed-bottom')
            if ($('.content_check_all').is(":checked")) $('.content_check_all').trigger("click");
            // $('.content_check_all').trigger("click");
        }
    });

    $(document).on('click', '.content_save_button',  function () {
        var articleIds = [];
        $('.content_list_check').each(function () {
            if ($(this).is(":checked")) {
                articleIds.push($(this).attr("data-id"));
            }
        });

        var group_action_text =  $(".content_select_action :selected").text();
        var group_action =  $(".content_select_action").val();

        bootbox.confirm({
            closeButton: false,
            message: 'Вы действительно хотите "' + group_action_text + '"?' ,
            callback: function(result) {
                console.log(result);
                if (result === true) {
                    $.post('index.php?mod=models&action=group', { articleIds: articleIds, group_action: group_action }, function (data) {
                        console.log(data);
                        new Noty({ text: data.message, type: data.type }).show();
                        if (data.status === 200) {
                            setTimeout(function() {
                                window.location.reload();
                            }, 1500);

                        }
                    }, 'json');
                }
            }
        });
    });

    $(document).on('click', '.save_setting_table', function () {
        var projectIds = [];
        $('input.table_column:checked').each(function() {
            projectIds.push($(this).val());
        });

        console.log("projectIds => " + projectIds);

        const order_field = $('.order_field :selected').val();

        const order_direction = $('.order_direction :selected').val();
        console.log("order_field => " + order_field);
        console.log("order_direction => " + order_direction);

        $.post('index.php?mod=models&action=settings', { "option[columns]": projectIds, "option[order_field]": order_field, "option[order_direction]": order_direction }, function (response) {
            console.log(response);
            new Noty({ text: response.message, type: response.type }).show();
            if (response.status == 200) {
                $('.close_setting_table').click();
                setTimeout(function() {
                    window.location.reload();
                }, 1500);
            }

        }, 'json');

    });
</script>




