<form method="post" enctype="multipart/form-data" class="form-content-wrapper">

	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$generate_url}?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$generate_url}" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

    <div class="content">

        <div class="row"> 
            <div class="col-md-12">

	            <div class="card border shadow-sm">
		            <div class="card-header d-flex flex-wrap">
			            <h6 class="mb-0">{general:card:general}</h6>
			            <div class="d-inline-flex ms-auto">
				            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			            </div>
		            </div>
		            <div class="collapse show">
			            <div class="card-body">
	                        <div class="row">
		                        <div class="col-md-6">
			                        <div class="form-group mb-3">
				                        <label class="form-label is-visible {if isset($errors.modelId)}text-danger{/if}">Модель</label>
                                        {html_options options=$models name="modification[modelId]" selected=$modification.modelId|default:'' class="form-control select"}
			                        </div>
		                        </div>
		                        <div class="col-md-6">
                                    {* field status *}
                                    {include file="components/fields/select.tpl" id="status" title="{general:status}" field="modification[status]" array=$statuses selected=$modification.status|default:'V' class="form-group mb-3"}
                                    {* /field status *}
		                        </div>
	                            <div class="col-md-3">
	                                <div class="form-group mb-3">
	                                    <label class="form-label {if isset($errors.title)}text-danger{/if}">Название модификации</label>
	                                    <input type="text" class="form-control" id="title" autocomplete="off" name="modification[name]" value="{$modification.name|default:''}">
	                                </div>
	                            </div>
					            <div class="col-md-3">
						            <div class="form-group mb-3">
							            <label class="form-label {if isset($errors.power)}text-danger{/if}">Объем двигателя</label>
							            <input  type="text" class="form-control" id="power" autocomplete="off" name="modification[engine_capacity]" value="{$modification.engine_capacity|default:''}" placeholder="1.5 л"/>
						            </div>
					            </div>
		                        <div class="col-md-3">
						            <div class="form-group mb-3">
							            <label class="form-label {if isset($errors.power)}text-danger{/if}">Мощность двигателя (л.с.)</label>
							            <input  type="text" class="form-control" id="power" autocomplete="off" name="modification[power]" value="{$modification.power|default:''}" placeholder="693 л.с."/>
						            </div>
					            </div>
								<div class="col-md-3">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.acceleration)}text-danger{/if}">Время разгона (0-100 км/ч, с)</label>
										<input  type="text" class="form-control" id="acceleration" autocomplete="off" name="modification[acceleration]" value="{$modification.acceleration|default:''}" placeholder="3.2 с."/>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Запас хода на электричестве</label>
										<input type="text" class="form-control" autocomplete="off" name="modification[power_reserve]" value="{$modification.power_reserve|default:''}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Емкость батареи</label>
										<input type="text" class="form-control" autocomplete="off" name="modification[battery_capacity]" value="{$modification.battery_capacity|default:''}">
									</div>
								</div>
		                        <div class="col-md-4">
			                        <div class="form-group mb-3">
				                        <label class="form-label {if isset($errors.engine)}text-danger{/if}">Тип двигателя</label>
                                        {html_options options=$engines name="modification[engine]" id="engines" selected=$modification.engine|default:'' class="form-control select"}
			                        </div>
		                        </div>
		                        <div class="col-md-4">
			                        <div class="form-group mb-3">
				                        <label class="form-label {if isset($errors.transmission)}text-danger{/if}">Трансмиссия</label>
                                        {html_options options=$transmissions name="modification[transmission]" id="transmission" selected=$modification.transmission|default:'' class="form-control select"}
			                        </div>
		                        </div>
		                        <div class="col-md-4">
			                        <div class="form-group mb-3">
				                        <label class="form-label {if isset($errors.gear)}text-danger{/if}">Привод</label>
                                        {html_options options=$gear_type name="modification[gear]" id="gear" selected=$modification.gear|default:'' class="form-control select" }
			                        </div>
		                        </div>

{*		                        <div class="col-md-4">*}
{*						            <div class="form-group mb-3">*}
{*							            <label class="form-label {if isset($errors.code)}text-danger{/if}">Код двигателя</label>*}
{*							            <input  type="text" class="form-control" id="code" autocomplete="off" name="modification[code]" value="{if isset($modification.code)}{$modification.code}{/if}" />*}
{*						            </div>*}
{*					            </div>*}

	                        </div>
			            </div>
                    </div>
    		    </div>


	            <div class="card">
		            <div class="card-header bg-transparent header-elements-inline">
			            <h6 class="card-title">Спецификация</h6>
			            <div class="header-elements">
				            <div class="list-icons">
					            <a class="list-icons-item" data-action="collapse"></a>
				            </div>
			            </div>
		            </div>
		            <div class="card-body">
                        {if isset($features) AND !empty($features)}
				            <table class="table">
					            <thead id="header">
					            <tr>
						            <th style="width: 40%;">Название</th>
						            <th style="width: 40%;">Значение</th>
						            <th style="width: 20%;">Единица измерения</th>
					            </tr>
					            </thead>
					            <tbody class="specification">
                                {foreach from=$features name=features item=feature}
						            <tr><th class="text-center" colspan="3">{$feature.name}</th></tr>
                                    {if isset($feature.specifications) AND !empty($feature.specifications)}
                                        {foreach from=$feature.specifications item=specific}
								            <tr>
									            <td class="ml-2">{$specific.name nofilter}</td>
									            <td><input class="form-control" type="text" name="specifications[{$specific.specificationId}][value]" value="{$specific.value|default:'' nofilter}"/></td>
									            <td><input class="form-control" type="text" name="specifications[{$specific.specificationId}][unit]" value="{$specific.unit|default:'' nofilter}"/></td>
								            </tr>
                                        {/foreach}
                                    {/if}
                                {/foreach}
					            </tbody>

				            </table>
                        {else}
				            <p class="mb-3 text-center"><code>Необходимо добавить или прикрепить уже существующий двигатель, свойства и спецификации</code></p>
                        {/if}
		            </div>
	            </div>

            </div>

	        <div class="col-md-12 main main_buttons text-center">
                {if isset($modification.modificationId)}
			        <input type="hidden" name="id" value="{$modification.modificationId}" />
                {/if}
                {$smarty.capture.buttons nofilter}
	        </div>

        </div>
    </div>
</form>


<script>


    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: 'Модификация сохранена', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.title)} new Noty({ text: '{articles:errors:1}', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.code)} new Noty({ text: 'Укажите код ', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Модификация не сохранена', type: 'error', timeout: 2500 }).show(); {/if}

        {if isset($errors.modelIds)} new Noty({ text: 'Выберите модель ', type: 'error', timeout: 2500 }).show(); {/if}
{*        {if isset($errors.equipmentIds)} new Noty({ text: 'Выберите комплектации ', type: 'error', timeout: 2500 }).show(); {/if}*}

    });
</script>
