<form method="post" enctype="multipart/form-data" id="{$module}">
	<!-- Page header -->
	{include file="components/group-buttons.tpl" url="{$generate_url}?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

	{capture name="breadcrumb"}
		<a href="{$generate_url}" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
	{/capture}

	{capture name="showBy"}{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">

		<div class="row">
			<div class="col-md-8">
				{* основные поля *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 mb-3">
									<div class="form-group form-group-float">
										<label class="form-label {if isset($errors.sectionId)}text-danger{/if}">{general:section}</label>
										{html_options options=$sections name="article[sectionId]" id="sectionId" selected=$article.sectionId|default:0 class="form-control form-control-sm select"}
									</div>
								</div>
								<div class="col-md-6 mb-3">
									<div class="form-group">
										<label class="form-label {if isset($errors.title)}text-danger{/if}">{general:title}</label>
										<input type="text" class="form-control" id="title" autocomplete="off" name="article[title]" value="{$article.title|default:''}" onblur="proposeFileName('title', 'fileName', '{$module}', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');">
									</div>
								</div>
								<div class="col-md-6 mb-3">
									<div class="form-group">
										<label class="form-label">{general:alias}</label>
										<input type="text" class="form-control" id="alias" autocomplete="off" name="article[alias]" value="{$article.alias|default:''}">
									</div>
								</div>
								<div class="col-md-12 mb-3">
									<div class="form-group">
										<label class="form-label {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{general:filename}</label>
										<input  type="text" class="form-control" id="fileName" autocomplete="off" name="article[fileName]" value="{$article.fileName|default:''}" />
									</div>
								</div>

								{foreach from=$fields item=field}{if $field.position eq 'M'}
									{if $field.type eq 'S'}
										{include file="components/fields/select.tpl" col="{$field.wrapper_class}" id="{$field.fileName}" title="{$field.name}" field="article[{$field.fileName}]" array=$field.properties selected=$article[$field.fileName]|default:'' class="form-group mb-3"}
									{elseif $field.type eq 'R'}
										{include file="components/fields/radio.tpl" col="{$field.wrapper_class}" id="{$field.fileName}" title="{$field.name}" field="article[{$field.fileName}]" array=$field.properties selected=$article[$field.fileName]|default:'' group=$field.radio_group_position class="form-group mb-3"}
									{elseif $field.type eq 'C'}
										{include file="components/fields/checkbox.tpl" col="{$field.wrapper_class}" id="{$field.fileName}" title="{$field.name}" field="article[{$field.fileName}]" selected=$article[$field.fileName]|default:'' class="form-group mb-3"}
									{elseif $field.type eq 'I'}
										{include file="components/fields/input.tpl" col="{$field.wrapper_class}" title="{$field.name}" name="field[{$field.fileName}]" value=$article[$field.fileName]|default:''}
									{elseif $field.type eq 'T'}
										{include file="components/fields/textarea.tpl" col="{$field.wrapper_class}" title="{$field.name}" name="field[{$field.fileName}]" value=$article[$field.fileName]|default:''}
									{elseif $field.type eq 'D'}
										{include file="components/fields/data.tpl" col="{$field.wrapper_class}" title="{$field.name}" name="field[{$field.fileName}]" value=$article[$field.fileName]|default:$adjustedNow}
									{/if}
								{/if}{/foreach}
							</div>
						</div>
					</div>
				</div>
				{* /основные поля *}

				{* фото галерея *}
				{if $modules.gallery}
					{include file="cards/card-gallery.tpl" galleries=$article.gallery|default:[] enable=$article.enableGallery|default:0 module='article'}
				{/if}
				{* /фото галерея *}


				{* текст summary/content *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:description}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0 p-0">
							<ul class="nav nav-tabs nav-tabs-overline border-top-0">
								<li class="nav-item"><a href="#summary" class="nav-link active show" data-bs-toggle="tab">{general:tabs:summary}</a></li>
								<li class="nav-item"><a href="#content" class="nav-link" data-bs-toggle="tab">{general:tabs:content}</a></li>
							</ul>

							<div class="tab-content border-top-0 rounded-top-0 mb-0">
								<div class="tab-pane fade show active" id="summary">
									<textarea id="description" name="article[summary]" class="description">{$article.summary|default:''}</textarea>
								</div>

								<div class="tab-pane fade" id="content">
									<textarea id="description" name="article[content]" class="description">{$article.content|default:''}</textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
				{* /текст описание *}

			</div>

			<div class="col-md-4">

				{* статус и видимость *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body border-top-0">
							{* field status *}
							{include file="components/fields/select.tpl" id="status" title="{general:status}" field="article[status]" array=$statuses selected=$article.status|default:'visible' class="form-group mb-3"}
							{* /field status *}

							{* ПРОДУМАТЬ НУЖЕН ЛИ НАМ ЭТОТ ПАРАМЕТР *}
							{if $modules.gallery}
								<div class="form-check mb-3">
									<input type="checkbox" class="form-check-input" id="enableGallery" name="article[enableGallery]" value="1" {if isset($article.enableGallery) and $article.enableGallery eq 1}checked{/if} data-bs-toggle="collapse" data-bs-target="#gallery-card">
									<label class="form-check-label" for="enableGallery">Фотогалерея к этой публикации</label>
								</div>
							{/if}

							<div class="form-group mb-3">
								<label class="form-label">{general:misc:publishDate}</label>
								<div class="input-group">
									<span class="input-group-text"><i class="ph-calendar"></i></span>
									<input type="text" class="form-control date-range-single" name="article[publishedOn]" value="{$article.publishedOn|default:$adjustedNow}" readonly>
								</div>
							</div>

							{if $modules.publishEnd}
								<div class="form-group mb-3">
									<label class="form-label">{general:misc:publishEnd}</label>
									<div class="input-group">
										<span class="input-group-text"><i class="ph-calendar"></i></span>
										<input type="text" class="form-control date-range-single" name="article[publicationEnd]" value="{$article.publicationEnd|default:$adjustedNow}" readonly>
									</div>
								</div>
							{/if}


							{* field isFeatured *}
							{include "components/fields/select.tpl" id="isFeatured" title="{articles:misc:featured}" field="article[isFeatured]" array=$paramIsFeatured selected=$article.isFeatured|default:0 class="form-group mb-3"}
							{* /field isFeatured *}

							{* field commentsEnabled *}
							{include file="components/fields/select.tpl" id="commentsEnabled" title="{general:comments}" field="article[commentsEnabled]" array=$paramSettingComments selected=$article.commentsEnabled|default:0 class="form-group mb-3"}
							{* /field commentsEnabled *}

							{foreach from=$fields item=field}{if $field.position eq 'S'}
								{if $field.type eq 'S'}
									{include file="components/fields/select.tpl" col="{$field.wrapper_class}" id="{$field.fileName}" title="{$field.name}" field="article[{$field.fileName}]" array=$field.properties selected=$article[$field.fileName]|default:'' class="form-group mb-3"}
								{elseif $field.type eq 'R'}
									{include file="components/fields/radio.tpl" col="{$field.wrapper_class}" id="{$field.fileName}" title="{$field.name}" field="article[{$field.fileName}]" array=$field.properties selected=$article[$field.fileName]|default:'' group=$field.radio_group_position class="form-group mb-3"}
								{elseif $field.type eq 'C'}
									{include file="components/fields/checkbox.tpl" col="{$field.wrapper_class}" id="{$field.fileName}" title="{$field.name}" field="article[{$field.fileName}]" selected=$article[$field.fileName]|default:'' class="form-group mb-3"}
								{elseif $field.type eq 'I'}
									{include file="components/fields/input.tpl" col="{$field.wrapper_class}" title="{$field.name}" name="field[{$field.fileName}]" value=$article[$field.fileName]|default:''}
								{elseif $field.type eq 'T'}
									{include file="components/fields/textarea.tpl" col="{$field.wrapper_class}" title="{$field.name}" name="field[{$field.fileName}]" value=$article[$field.fileName]|default:''}
								{elseif $field.type eq 'D'}
									{include file="components/fields/data.tpl" col="{$field.wrapper_class}" title="{$field.name}" name="field[{$field.fileName}]" value=$article[$field.fileName]|default:$adjustedNow}
								{/if}
							{/if}{/foreach}

						</div>
						{if isset($article.addedOn) && isset($article.modifiedOn)}
							<div class="card-footer hstack gap-3 justify-content-between">
								<div class="text-muted">
									<ul class="list list-unstyled mb-0 fs-sm">
										<li>{general:created}</li>
										<li>{general:modified}</li>
									</ul>
								</div>
								<div class="hstack gap-1">
									<ul class="list list-unstyled mb-0 fs-sm">
										<li>{$article.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$article.addedBy.loginName|default:"{general:unknownUser}"})</li>
										<li>{$article.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$article.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
									</ul>
								</div>
							</div>
						{/if}
					</div>
				</div>
				{* /статус и видимость *}

				{* image preview *}
				{if $modules.image}
					{include file="cards/card-image.tpl"
					image="{if isset($article.image)}{$article.image.original}{/if}"
					id="{if isset($article.image)}{$article.image.imageId}{/if}"
					module='article'}
				{/if}
				{* /image preview *}

				{* DOCUMENT *}
				{if $modules.document}
					{include file="cards/card-documents.tpl"
					cardName="Файлы (pdf, word)"
					docs=$article.docs|default:[]
					module='article'}
				{/if}
				{* /DOCUMENT *}

				{* SEO *}
				{if $modules.seo}
					{include file="cards/card-seo.tpl"
					cardName="{general:card:seo}"
					content=$article|default:[]
					module='article'}
				{/if}
				{* /SEO *}
			</div>

			<div class="col-md-12 text-center">
				{if isset($article.articleId)}<input type="hidden" class="form-control" id="id" name="id" value="{$article.articleId|default:''}">{/if}
				{$smarty.capture.buttons nofilter}
			</div>

		</div>

	</div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>


	$(document).ready(function () {

		{if isset($messages.saved)} new Noty({ text: '{articles:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}

		{if isset($errors.title)} new Noty({ text: '{articles:errors:1}', type: 'error', timeout: 2500 }).show();{/if}
		{if isset($errors.access_denied)} new Noty({ text: '{articles:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
		{if isset($errors.sectionId)} new Noty({ text: '{articles:errors:2}', type: 'error', timeout: 2500 }).show(); {/if}
		{if isset($errors.not_saved)} new Noty({ text: '{articles:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
		{if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
		{if isset($errors.image_not_saved)} new Noty({ text: '{articles:errors:5}', type: 'error', timeout: 2500 }).show(); {/if}
		{if isset($errors.article_not_found)} new Noty({ text: '{articles:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}
		{if isset($errors.fileName)} new Noty({ text: '{articles:errors:7}', type: 'error', timeout: 2500 }).show(); {/if}
		{if isset($errors.fileNameExists)} new Noty({ text: '{articles:errors:8}', type: 'error', timeout: 2500 }).show(); {/if}

		// сортировать фотогалерею
		$(document).on('click', '.sortable_save_button', function () {
			var ids = new Array();
			$('#fileList figure.gallery-item').each(function () {
				console.log($(this).attr('data-id'))

				ids.push($(this).attr('data-id'));
			})
			$.post( "{$generate_url|substr:0:-1}?action=sortPictures", { imageIds : ids }, function(response) {
				$('.sortable_footer_navbar').removeClass('show');
				$("#fileList").load(location.href + " figure.gallery-item");
				new Noty({ text: response.message, type: response.type }).show();
			});
		})
		$(document).on('click', '.sortable_cancel_button', function () {
			$('.sortable_footer_navbar').removeClass('show');
			$("#fileList").load(location.href + " figure.gallery-item");
		})




	});


	$(function () {
		function e() {
			keywords_touched || $("#keywords").val(i()),
			description_touched || $("#description").val(t()),
			fileName_touched || $("#fileName").val(n())
		}
		function i() {
			return name = $("#title").val()
		}
		function t() {
			return name = $("#title").val()
		}
		function n() {
			return fileName = $("#title").val(),
					fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"),
					fileName = l(fileName),
					fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase()
		}
		function l(e) {
			for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"),
						 i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"),
						 t = "", n = 0, l = e.length; l > n; n++) {
				var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o
			}
			return t
		}
		keywords_touched = !0, description_touched = !0, fileName_touched = !0,
		($("#keywords").val() == i() || "" == $("#keywords").val()) && (keywords_touched = !1),
		($("#description").val() == t() || "" == $("#description").val()) && (description_touched = !1),
		($("#fileName").val() == n() || "" == $("#fileName").val()) && (fileName_touched = !1),
				$("#keywords").change(function () {
					keywords_touched = !0
				}),
				$("#description").change(function () {
					description_touched = !0
				}),
				$("#fileName").change(function () {
					fileName_touched = !0
				}),
				$("#title").keyup(function () {
					e()
				})
	});

</script>
