
<!-- Page header -->
{capture name="buttons"}
    <a class="btn btn-sm btn-icon btn-primary me-2" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-plus"></i></a>

    {if $adminManager.userType eq $DEVELOPER}
        <a class="btn btn-sm btn-icon btn-primary" data-bs-popup="tooltip" title="Настройки контента" data-bs-placement="auto" href="/admin/contenttypes"><i class="ph-sliders"></i></a>
    {/if}
{/capture}

{capture name="breadcrumb"}
	<a href="{$generate_url}" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url=$generate_url}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<!-- Content area -->
<div class="content">

	<div class="row">
		<div class="col-md-12">
            {if empty($sections)}
				<div class="card border shadow-sm">
					<div class="alert bg-danger text-white alert-dismissible m-0">
						<span class="font-weight-semibold">Перед добавлением контента необходимо создать хотя бы один<a href="{$adminUrl}/section?action=add&parentId=0" class="alert-link text-white">раздел</a> с выбранным типом контента.</span>
					</div>
				</div>
            {/if}

			<div class="card border shadow-sm">
                {include file="components/selectors.tpl" isFilter=true url=$generate_url filterDate=true}
			</div>

			<div class="card card_check_button collapse">
				<div class="card-header bg-light py-2 header-elements-sm-inline">
					<div class="header-elements">
						<ul class="list-inline list-inline-condensed mb-0">
							<button class="btn btn-sm btn-primary" type="button">Удалить выбранное</button>
						</ul>
					</div>
				</div>
			</div>

			<div class="card border shadow-sm">
{*				<div class="card-header d-flex flex-wrap">*}
				<div class="card-header d-flex justify-content-between">
                    <a href="{$generate_url|substr:0:-1}?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}" class="btn btn-sm btn-primary me-auto" title="{general:add}"><i class="ph-plus me-2"></i>{general:add}</a>
{*                    {if isset($sortOrder.column)}*}
{*                    <button class="btn btn-sm btn-primary" onclick="clearTableSort(this, '{$module}'); return false;" type="button"><i class="ph-check me-2"></i>Сбросить сортировку</button>*}
{*                    {/if}*}
				</div>

				<div class="">
					<table class="table table-xs table-togglable table-striped table-hover" id="{$module}">
						<thead>
						<tr>
							<th class="text-center" width="30">
								<div class="form-check">
									<input type="checkbox" class="form-check-input content_check_all">
								</div>
							</th>
							<th class="text-center gridjs-th-sort main-th-col-sortable" onclick="tableSort(this, '{$module}'); return false;" data-sort-by="publishedOn" data-sort-order="{if isset($sortOrder.column) && $sortOrder.column eq 'publishedOn'}{if $sortOrder.sort eq 'asc'}desc{else}asc{/if}{else}asc{/if}" width="100">{general:table:date} <button class="gridjs-sort gridjs-sort-{if isset($sortOrder.column) && $sortOrder.column eq 'publishedOn'}{$sortOrder.sort}{else}neutral{/if}"></button></th>
							<th class="text-center" width="120">{general:table:image}</th>
							<th class="text-start gridjs-th-sort main-th-col-sortable" onclick="tableSort(this, '{$module}'); return false;" data-sort-by="title" data-sort-order="{if isset($sortOrder.column) && $sortOrder.column eq 'title'}{if $sortOrder.sort eq 'asc'}desc{else}asc{/if}{else}asc{/if}">{general:table:name} <button class="gridjs-sort gridjs-sort-{if isset($sortOrder.column) && $sortOrder.column eq 'title'}{$sortOrder.sort}{else}neutral{/if}"></button></th>
							<th class="text-center gridjs-th-sort main-th-col-sortable" onclick="tableSort(this, '{$module}'); return false;" data-sort-by="sectionId" data-sort-order="{if isset($sortOrder.column) && $sortOrder.column eq 'sectionId'}{if $sortOrder.sort eq 'asc'}desc{else}asc{/if}{else}asc{/if}">{general:table:section} <button class="gridjs-sort gridjs-sort-{if isset($sortOrder.column) && $sortOrder.column eq 'sectionId'}{$sortOrder.sort}{else}neutral{/if}"></button></th>
                            <th class="text-center text-muted" width="30">
                                <div class="btn-group">
                                    <a href="javascript:void(0);" class="align-items-center text-body dropdown-toggle" data-bs-toggle="dropdown"><i class="ph-gear"></i></a>
                                    <div class="dropdown-menu" style="">
                                        <button class="dropdown-item" onclick="clearTableSort(this, '{$module}'); return false;" type="button"><i class="ph-check me-2"></i>Сбросить сортировку</button>
                                    </div>
                                </div>
                            </th>
						</tr>
						</thead>
                        {if !empty($articles)}
							<tbody>
                            {foreach item=article from=$articles name=articles}
								<tr id="{$module|substr:0:-1}-{$article.articleId}" data-id="{$article.articleId}" class="{if $article.status eq 'H'}table-warning{/if}{if $article.status eq 'P'}table-danger{/if} {if $article.isFeatured}table-success{/if}">
									<td class="text-center">
										<div class="form-check">
											<input type="checkbox" class="form-check-input content_list_check" value="{$article.articleId}" data-id="{$article.articleId}">
										</div>
									</td>
									<td class="text-left text-nowrap"><span>{$article.publishedOn|date_format:$config.date_format_custom}</span></td>
									<td class="text-center"><div class="preview preview-md"><img src="{$article.image}" class="img-thumbnail w-80px" alt="{$article.title}"/></div></td>
									<td class="text-start"><a class=fw-semibold" href="{$SITE_URL}{$article.url}" target="_blank">{$article.title|truncate:75}</a></td>
									<td class="text-center">{$article.section|truncate:25}</td>
									<td class="text-center">
										<div class="d-inline-flex">
											<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit&id={$article.articleId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
											<div class="dropdown">
												<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
												<div class="dropdown-menu dropdown-menu-end">
                                                    <a class="dropdown-item" href="{$generate_url|substr:0:-1}?action=edit&id={$article.articleId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>

                                                    {include file="components/actions/dropdown-favorites.tpl" module="articles" id=$article.articleId isFeatured=$article.isFeatured scope=parent}
                                                    {include file="components/actions/dropdown-{if $article.status ne 'P'}status{else}approve{/if}.tpl" module="articles" id=$article.articleId status=$article.status scope=parent}

                                                    {include file="components/actions/dropdown-delete.tpl" id=$article.articleId title="{$article.title|escape|default:''}" module="{$module}" scope=parent}
												</div>
											</div>
										</div>
									</td>
								</tr>
                            {/foreach}
							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$generate_url}" params="{$buildQueryString}"}
			</div>
		</div>

	</div>
</div>

<script>
    $(document).ready(function () {

        {if isset($messages.saved)} new Noty({ text: '{articles:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.access_denied)} new Noty({ text: '{articles:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)}   new Noty({ text: '{articles:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{articles:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}

        {if isset($notice)} new Noty({ text: {$notice}, type: 'error', timeout: 2500 }).show(); {/if}

    });


    // выбрать все
    $(document).on("change", ".content_check_all", function () {
        if ($(this).is(":checked")) {
            $('.content_list_check').each(function () {
                if (!$(this).is(":checked")) $(this).trigger("click");
            });
            $('.footer_navbar').removeClass('collapse').addClass('fixed-bottom')
        } else {
            $('.content_list_check').each(function () {
                if ($(this).is(":checked")) $(this).trigger("click");
            });
            $('.footer_navbar').addClass('collapse').removeClass('fixed-bottom')
        }
    });

    // выбрать один
    $(document).on("change", ".content_list_check", function () {
        if ( $('input.content_list_check:checked').length > 0 ) {
            $('.footer_navbar').removeClass('collapse').addClass('fixed-bottom')

        } else {
            $('.footer_navbar').addClass('collapse').removeClass('fixed-bottom')
            if ($('.content_check_all').is(":checked")) $('.content_check_all').trigger("click");
            // $('.content_check_all').trigger("click");
        }
    });

    $(document).on('click', '.content_save_button',  function () {
        var articleIds = [];
        $('.content_list_check').each(function () {
            if ($(this).is(":checked")) {
                articleIds.push($(this).attr("data-id"));
            }
        });

        var group_action_text =  $(".content_select_action :selected").text();
        var group_action =  $(".content_select_action").val();

        bootbox.confirm({
            closeButton: false,
            message: 'Вы действительно хотите "' + group_action_text + '"?' ,
            callback: function(result) {
                console.log(result);
                if (result === true) {
                    $.post('index.php?mod={$module}&action=group', { articleIds: articleIds, group_action: group_action }, function (data) {
                        console.log(data);
                        new Noty({ text: data.message, type: data.type }).show();
                        if (data.status === 200) {
                            setTimeout(function() {
                                window.location.reload();
                            }, 1500);

                        }
                    }, 'json');
                }
            }
        });
    });

    $(document).on('click', '.save_setting_table', function () {
        var projectIds = [];
        $('input.table_column:checked').each(function() {
            projectIds.push($(this).val());
        });

        console.log("projectIds => " + projectIds);

        const order_field = $('.order_field :selected').val();

        const order_direction = $('.order_direction :selected').val();
        console.log("order_field => " + order_field);
        console.log("order_direction => " + order_direction);

        $.post('index.php?mod={$module}&action=settings', { "option[columns]": projectIds, "option[order_field]": order_field, "option[order_direction]": order_direction }, function (response) {
            console.log(response);
            new Noty({ text: response.message, type: response.type }).show();
            if (response.status == 200) {
                $('.close_setting_table').click();
                setTimeout(function() {
                    window.location.reload();
                }, 1500);
            }

        }, 'json');

    });
</script>




