<!-- Page header -->
{capture name="buttons"}
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/feedbacks" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/feedbacks"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


<!-- Content area -->
<div class="content">

	<div class="row">
		<div class="col-md-12">
			<div class="card">
                {include file="components/selectors.tpl" isFilter=true url="{$adminUrl}/feedbacks" filterDate=true}
			</div>

			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-xs table-togglable table-striped table-hover mails-archive" id="feedbacks">
						<thead>
						<tr>
							<th class="text-center" width="100">{users:table:date}</th>
							<th class="text-start">Ф.И.О.</th>
							<th class="text-start">{users:table:email}</th>
							<th class="text-start">{users:table:phone}</th>
							<th class="text-start">Сообщение</th>
							<th class="text-center">{general:table:status}</th>
							<th class="text-center text-muted" data-width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if !empty($feedbacks)}
							<tbody>
                            {foreach item=feedback from=$feedbacks name=feedbacks}
								<tr id="feedback-{$feedback.id}" data-id="{$feedback.id}" class="{if $feedback.status eq 'hidden'}table-warning{/if}">
									<td class="text-center text-nowrap"><b>{$feedback.created}</b></td>
									<td class="text-start">{$feedback.fullName}</td>
									<td class="text-start">{$feedback.email}</td>
									<td class="text-start">{$feedback.phone}</td>
									<td class="text-start"><span class="fw-semibold">{$feedback.subject nofilter}</span><br><br>{$feedback.message nofilter}</td>
									<td class="text-start">
										{html_options options=$statuses name="feedback[status]" id="status_{$feedback.id}" selected=$feedback.status|default:"" data-id="{$feedback.id}" class="form-control select change_status"}
									</td>
									<td class="text-center">
										<div class="d-inline-flex">
											<a class="text-primary btn btn-link p-1" data-bs-popup="tooltip" title="Читать" data-bs-placement="auto" href="{$adminUrl}/feedback?action=read&id={$feedback.id}"><i class="ph-note-pencil"></i></a>
											<button class="dropdown-item text-danger ms-2" onclick="remove({$feedback.id}, '{$feedback.fullName|escape|default:''}', 'feedbacks');"><i class="ph-trash me-2"></i></button>
										</div>
									</td>
								</tr>
                            {/foreach}

							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/feedbacks" params="{$buildQueryString}"}
			</div>
		</div>

	</div>
</div>

<script>

	$(document).on('change', '.change_status', function () {
        var $this = $(this), id = $this.attr('data-id'), status = $this.val();

		// Make the POST request with Fetch API
		fetch("{$adminUrl}/feedbacks?action=status", {
			method: 'POST',
			headers: {
				'Content-Type': 'application/json',
			},
			body: JSON.stringify({ id: id, status: status})
		}).then(response => response.json()).then(data => {
			new Noty({ text: data.message, type: data.type }).show();
		}).catch(error => {
			console.error('Error:', error);
		});

    })

</script>
