
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-primary btn-icon btn-sm me-2"
		   data-bs-popup="tooltip"
		   title="{general:add}"
		   data-bs-placement="auto" href="{$adminUrl}/section?action=add{if !empty($page)}&page={$page}{/if}{if !empty($parentId)}&parentId={$parentId}{/if}">
			<i class="ph-plus"></i>
		</a>

		{if $adminManager.userType eq $DEVELOPER}
			<a class="btn btn-sm btn-icon btn-primary" data-bs-popup="tooltip" title="Настройки контента" data-bs-placement="auto" href="/admin/contenttypes"><i class="ph-sliders"></i></a>
		{/if}
    {/capture}

    {capture name="breadcrumb"}
		<a class="breadcrumb-item" href="{$adminUrl}/sections">{$title} </a>
        {if isset($parent)}
			<a class="breadcrumb-item" href="{$adminUrl}/sections"> {sections:upToRoot}</a>
            {if isset($parent.parentId)}
				<a class="breadcrumb-item" href="{$adminUrl}/sections?parentId={$parent.parentId}">{if isset($parent.name)} {$parent.name}{/if}</a>
            {/if}
        {/if}
    {/capture}

    {capture name="showBy"}
        {include file="module/show-by.tpl" url="{$adminUrl}/sections"}
    {/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}

	<div class="content">
		<div class="row">
			<div class="col-md-12">

                {if isset($action) && $action == 'confirmDelete'}
					<div class="card border shadow-sm">
						<div class="alert bg-danger text-white alert-dismissible m-0">
							<span class="font-weight-semibold">{sections:deleting} "{if isset($section.name)}{$section.name nofilter}{/if}"</span><br />
							<span>{sections:deleteSectionQuestion}?</span>
						</div>
					</div>
					<div class="card border shadow-sm">
						<form action="{$adminUrl}/sections" method="post" id="confirmDelete">
                            {if !empty($section.hasSubsections) || !empty($section.hasArticles)}
							<div class="card-body">
								<div class="row">
									{if isset($subsectionOptions)}
										<div class="{if isset($articleOptions)}col-md-6{else}col-md-12{/if}">
											<div class="form-group mb-2">
												<label class="form-label is-visible">{sections:subsectionsAndArticles}</label>
												{html_options options=$subsectionOptions name="param[moveSubsectionsTo]" class="form-control form-control-sm select"}
											</div>
										</div>
									{/if}
									{if isset($articleOptions)}
										<div class="{if isset($subsectionOptions)}col-md-6{else}col-md-12{/if}">
											<div class="form-group">
												<label class="form-label is-visible">{articles:title}</label>
												{html_options options=$articleOptions name="param[moveArticlesTo]" class="form-control form-control-sm select"}
											</div>
										</div>
									{/if}
								</div>
							</div>
                            {/if}
							<div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
								<input type="hidden" name="id" value="{if isset($section.sectionId)}{$section.sectionId}{/if}" />
								<input type="hidden" name="parentId" value="{if isset($parentId)}{$parentId}{/if}" />
								<button class="btn btn-sm btn-primary" type="submit" name="action" value="deleteConfirmed">{general:yes}</button>
								<a class="btn btn-sm btn-light" href="{$adminUrl}/sections?parentId={$parentId}">{general:cancel}</a>
							</div>
						</form>
					</div>

                {else}

					<div class="card border shadow-sm">
						<div class="">
							<table class="table table-togglable table-xs table-striped table-hover" id="sections">
								<thead>
								<tr>
									<th data-hide="phone, tablet" class="text-center" width="30">#</th>
									<th data-toggle="true" class="">{general:table:name}</th>
									<th data-hide="phone, tablet">{general:table:alias}</th>
									<th data-hide="phone, tablet">{general:table:path}</th>
									<th data-hide="phone, tablet" width="80">{general:table:type}</th>
									<th data-hide="phone, tablet" width="140">{general:table:contentType}</th>
									<th class="text-center text-muted" width="50"><i class="ph-check"></i></th>
								</tr>
								</thead>
                                {if isset($sections)}
									<tbody class="sortable">
                                    {foreach item=section from=$sections name=sections}
										<tr id="section-{$section.sectionId}" data-id="{$section.sectionId}" class="{if $section.status eq 'H'}table-warning{/if}">
											<td class="text-center text-nowrap"><i class="ph-dots-six text-muted" data-bs-popup="tooltip" title="Переместить" data-bs-placement="auto"></i></td>
											<td class="text-nowrap">
                                                {if !empty($section.hasSubsections)}
													<a data-bs-popup="tooltip" title="{$section.name}" data-bs-placement="auto" href="{$adminUrl}/sections?parentId={$section.sectionId}" style="border-bottom: 1px dashed;">{$section.name|strip_tags|truncate:25}</a>
                                                {else}
													<span data-bs-popup="tooltip" title="{$section.name}" data-bs-placement="auto">{$section.name|strip_tags|truncate:25}</span>
                                                {/if}
											</td>
											<td class="text-nowrap"><span data-bs-popup="tooltip" title="{$section.alias}" data-bs-placement="auto">{$section.alias|strip_tags|truncate:25}</span></td>
											<td class="text-nowrap"><a href="{$SITE_URL}{$section.url}" data-bs-popup="tooltip" title="{general:view}" data-bs-placement="auto" target="_blank">{if $section.fileName eq 'index'}/{else}/{$section.fileName}/{/if}</a></td>
											<td class="text-nowrap">{$section.typeName}</td>
											<td class="text-nowrap">{$section.contentTypeName}</td>
											<td class="text-end">
												<div class="d-inline-flex">
													<div class="text-body">
														<div class="form-check form-switch" data-bs-popup="tooltip" title="Добавить или скрыть в основном меню" data-bs-placement="auto">
															<input type="checkbox" class="form-check-input form-check-input-success top_menu" data-id="{$section.sectionId}" {if $section.headerMenu eq '1'}checked{/if}>
														</div>
													</div>
													<a class="text-primary mx-2" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/section?action=edit&id={$section.sectionId}{if $parentId}&parentId={$parentId}{/if}{if isset($page)}&page={$page}{/if}"><i class="ph-note-pencil"></i></a>
													<div class="dropdown">
														<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
														<div class="dropdown-menu dropdown-menu-end">
															<a class="dropdown-item" href="{$adminUrl}/section?action=edit&id={$section.sectionId}{if $parentId}&parentId={$parentId}{/if}{if isset($page)}&page={$page}{/if}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
															{include file="components/actions/dropdown-status.tpl" module="sections" id=$section.sectionId status=$section.status scope=parent}
                                                            {if $section.fileName ne 'index'}
																<div class="dropdown-divider"></div>
																<a class="dropdown-item text-danger" href="{$adminUrl}/sections?action=confirmDelete&id={$section.sectionId}{if $parentId}&parentId={$parentId}{/if}{if !empty($page)}&page={$page}{/if}"><i class="ph-trash me-2"></i> {general:delete}</a>
                                                            {/if}
														</div>
													</div>
												</div>
											</td>
										</tr>
                                    {/foreach}


									</tbody>
                                {else}
									<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                                {/if}
							</table>
						</div>
                        {include file="module/pagination.tpl" url="{$adminUrl}/sections" params="{if $parentId}&parentId={$parentId}{/if}"}
					</div>

                {/if}
			</div>
		</div>
	</div>

	<script>

	    $(document).ready(function () {

	        {if isset($errors.not_saved)} new Noty({ text: '{sections:errors:0}', type: 'error' }).show();{/if}
	        {if isset($errors.section_not_found)} new Noty({ text: '{sections:errors:1}', type: 'error' }).show(); {/if}

	        {if isset($messages.saved)} new Noty({ text: '{sections:messages:0}', type: 'success' }).show(); {/if}
	        {if isset($messages.deleted)} new Noty({ text: '{sections:messages:1}', type: 'success' }).show(); {/if}
	        {if isset($messages.sorted)} new Noty({ text: '{sections:messages:2}', type: 'success' }).show(); {/if}

	    });

	    function moveUpMessage(){ new Noty({ text: '{sections:messages:3}', type: 'warning' }).show(); }
	    function moveDownMessage(){ new Noty({ text: '{sections:messages:4}', layout: 'topRight', type: 'warning' }).show(); }
	    function downMenuMessage(){ new Noty({ text: '{sections:messages:7}', type: 'warning' }).show(); }
	    {*function sectionVisibleMessage(){ new Noty({ text: '{sections:messages:8}', type: 'warning' }).show(); }*}
	    {*function sectionHiddenMessage(){ new Noty({ text: '{sections:messages:9}', type: 'warning' }).show(); }*}


	    $(document).on('click', '.top_menu', function() {
	        var id = $(this).attr("data-id");
	        $.post("{$adminUrl}/sections?action=menu", { id: id }, function(data){
	            console.log(data.check);
	            if (data.check === 1) {
	                new Noty({ text: '{sections:messages:6} 👍', layout: 'topCenter', type: 'warning' }).show();
	            } else{
	                new Noty({ text: '{sections:messages:7} 👍', layout: 'topCenter', type: 'warning' }).show();
	            }
	        }, 'json');
	    });

	    $(document).on('click', '.sortable_save_button', function () {
	        var sectionIds = new Array();
	        $('.sortable tr').each(function () {
		        sectionIds.push($(this).attr('data-id'));
	        })
	        $.post( "{$adminUrl}/sections?action=reorder", { sectionIds : sectionIds }, function( data ) {
	            $('.sortable_footer_navbar').removeClass('show');
	            // location.reload();
	        });
	    })
	    $(document).on('click', '.sortable_cancel_button', function () {
	        $('.sortable_footer_navbar').removeClass('show');
	        location.reload();
	    })

	</script>





