<form method="post" id="social" >
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/socials?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/socials" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<!-- Content area -->
    <div class="content">
        <div class="row"> 
            <div class="col-md-12">
    
    		    <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:general}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">

	                        <div class="row">
								<div class="col-12">
                                    {* field status *}
                                    {include file="components/fields/select.tpl" col="col-12" id="status" title="{general:status}" field="social[status]" array=$statuses selected=$social.status|default:'V' class="form-group mb-3"}
                                    {* /field status *}
								</div>
	                            <div class="col-md-6">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible {if isset($errors.errorName)}text-danger{/if}">{socials:name}</label>
	                                    <input type="text" class="form-control" autocomplete="off" id="name" name="social[name]" value="{$social.name|default:''}">
	                                </div>
	                                 <div class="form-group  mb-3">
	                                    <label class="form-label is-visible {if isset($errors.fileNameEmpty) or isset($errors.fileNameError)}text-danger{/if}">{socials:fileName}</label>
	                                    <input type="text" class="form-control" autocomplete="off" id="fileName" name="social[fileName]" value="{$social.fileName|default:''}">
	                                </div>
	                            </div>

	                            <div class="col-md-6">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible">{socials:url}</label>
	                                    <input type="text" class="form-control" autocomplete="off" id="url" name="social[url]" value="{$social.url|default:''}" />
	                                </div>
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible">{socials:icon}</label>
	                                    <input type="text" class="form-control" autocomplete="off" id="icon" name="social[icon]" value="{$social.icon|default:''}"/>
	                                </div>

	                            </div>
	                        </div>
	                    </div>
                        {if isset($social.addedOn) &&  isset($social.modifiedOn)}
				        <div class="card-footer hstack gap-3 justify-content-between">
					        <div class="text-muted">
						        <ul class="list list-unstyled mb-0 fs-sm">
                                    <li>{general:created}</li>
                                    <li>{general:modified}</li>
						        </ul>
					        </div>
					        <div class="hstack gap-1">
						        <ul class="list list-unstyled mb-0 fs-sm">
                                    <li>{$social.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$social.addedBy.loginName|default:"{general:unknownUser}"})</li>
                                    <li>{$social.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$social.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
						        </ul>
					        </div>
				        </div>
                        {/if}
			        </div>
    		    </div>
            </div>

	        <div class="col-md-12 main main_buttons text-center">
                {if isset($social.socialId)}<input type="hidden" class="form-control" id="id" name="id" value="{$social.socialId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
	        </div>

        </div>
    </div>
</form>

<script>
    $(document).ready(function() {
        {if isset($errors.errorName)} new Noty({ text: '{socials:errors:0}', type: 'error'}).show(); {/if}
        {if isset($errors.fileNameEmpty)} new Noty({ text: '{socials:errors:1}', type: 'error'}).show(); {/if}
        {if isset($errors.fileNameError)} new Noty({ text: '{socials:errors:2}', type: 'error' }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{socials:errors:3}', type: 'error' }).show(); {/if}

        {if isset($messages.saved)} new Noty({ text: '{socials:messages:0}', type: 'success' }).show(); {/if}
    });
    function deleteMessage() {
        new Noty({ text: '{socials:messages:1}', type: 'success' }).show();
    }
    
    $(function () {
        function e() { fileName_touched || $("#fileName").val(n()) }
        function n() { return fileName = $("#name").val(), fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"), fileName = l(fileName), fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase() }
        function l(e) { for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"), i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"), t = "", n = 0, l = e.length; l > n; n++) { var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o } return t }
        fileName_touched = !0, ($("#fileName").val() == n() || "" == $("#fileName").val()) && (fileName_touched = !1), $("#fileName").change( function () { fileName_touched = !0 }), $("#name").keyup( function () { e() })
    });
            
</script>