
	<!-- Page header -->
	{capture name="buttons"}
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/bots" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/bots"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
		<div class="row">
			<div class="col-md-12">

				<div class="card border shadow-sm">
					{include file="components/selectors.tpl" action="{$adminUrl}/bots" select=''}
				</div>

			    <div class="card border shadow-sm">
				    <div class="card-header d-flex flex-wrap">
					    <h6 class="mb-0">{$title}</h6>
					    <div class="d-inline-flex ms-auto">
						    <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
					    </div>
				    </div>
				    <div class="collapse show">
			            <table class="table table-xs table-striped table-actions table-hover">
				            <thead>
				            <tr>
				                <th class="text-left">{stats:useragent}</th>
				                <th class="text-center">{stats:visits}</th>
				            </tr>
				            </thead>
				            {if isset($visitors) && !empty($visitors)}
				                <tbody>
				                {foreach item=visitor from=$visitors}
				                    <tr class="">
				                        <td class="text-nowrap" width="100%">{if isset($visitor.botName)}{$visitor.botName|default:$visitor.userAgent nofilter}{/if}</td>
				                        <td class="text-center"><a href="{$adminUrl}/bot?visitorId={$visitor.visitorId}{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}">{$visitor.totalVisits}</a></td>
				                    </tr>
				                {/foreach}
				                </tbody>
				            {else}
				                <tbody> <tr class="odd"><td class="text-center" colspan="2">- {general:none} -</td></tr></tbody>
				            {/if}

				        </table>
				    </div>
	                {include file="module/pagination.tpl" url="{$adminUrl}/bots" params="{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}"}
			    </div>
			</div>
		</div>
	</div>
	<!-- /content area -->
