
<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-icon btn-primary" data-bs-popup="tooltip" title="{general:add} группу" data-bs-placement="auto" href="{$adminUrl}/group?action=add{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-plus"></i></a>
{/capture}
{capture name="breadcrumb"}
	<a href="{$adminUrl}/groups" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/manager-groups"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<!-- Content area -->
<div class="content">

	<div class="row">
		<div class="col-md-12">

			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-togglable table-xs table-striped table-hover users-archive" id="groups">
						<thead>
						<tr>
							<th width="160">Дата изменения</th>
							<th class="">Название группы</th>
							<th class="">Кол-во участников</th>
							<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if isset($groups)}
							<tbody>
                            {foreach item=group from=$groups name=groups}
								<tr id="group-{$group.groupId}" class="{if $group.status eq 'H'}table-warning{/if}">
									<td class="text-left text-nowrap"><span class="fs-sm fw-semibold">{$group.dateChange}</span></td>
									<td class="">{$group.groupName nofilter}</td>
									<td class=""><span class="fw-semibold">{$group.countUsers|default:0}</span> <span class="fs-sm">({$group.countUsers|plural:'по...ль':'по...лей':'по...ля'|lower})</span></td>
									<td class="text-left">
										<div class="d-inline-flex">
											<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/group?action=edit&id={$group.groupId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
                                            {if !$smarty.foreach.groups.first}
												<div class="dropdown">
													<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

													<div class="dropdown-menu dropdown-menu-end">
														<a class="dropdown-item" href="{$adminUrl}/group?action=edit&id={$group.groupId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i>{general:edit}</a>
														{include file="components/actions/dropdown-status.tpl" module="groups" id=$group.groupId status=$group.status scope=parent}
														{include file="components/actions/dropdown-delete.tpl" id=$group.groupId title="{$group.groupName|escape|default:""}" module="groups" scope=parent}
													</div>
												</div>
                                            {/if}
										</div>
									</td>
								</tr>
                            {/foreach}

							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/groups" params="{$buildQueryString}"}

			</div>
		</div>

	</div>
</div>

