<?php

namespace Mnv\Core;

use Mnv\Core\Database\Connection;
use Mnv\Core\Singleton\SingletonTrait;

/**
 * Class DB
 * @package Mnv\Core
 */
final class DB extends Connection
{
    use SingletonTrait;

    /** DB constructor. */
    private function __construct()
    {
        $config = include GLOBAL_ROOT .'/includes/config.inc.php';

        parent::__construct($config);
    }

    /**  @return Connection  */
    public function connect(): Connection
    {
        return $this;
    }


}