<?php

namespace Mnv\Core\Security\Csrf\Interfaces;

/**
 * Class SessionProvider
 * @package Mnv\Core\Security\Csrf
 */
interface SessionProvider
{
    /**
     * Get a session value.
     *
     * @param string $key
     * @return mixed
     */
    public function get(string $key);

    /**
     * Set a session value.
     *
     * @param string $key
     * @param mixed $value
     * @return void
     */
    public function set(string $key, $value);
}
