<?php

namespace Mnv\Core\Table\Parser;
/**
 * Определяет интерфейс парсера define parser interface
 *
 * @package JSONParser
 */
interface IParser
{
    public function getCell(int $row_num, int $col);
    public function getColumn(int $col);
    public function getRow(int $row_num);
    public function getField();
    public function isCellExists(int $row_num, int $col);
    public function isColumnExists(int $col);
    public function isRowExists(int $row_num);
    public function isFieldExists();
    public function isFileReady(string $file_path);
    public function loadFile(string $file_path);
    public function loadString(string $json);
}