<?php

namespace Mnv\Core\Table\Writer;

/**
 * SimpleExcel class for writing table as JSON
 *
 * @package JSONParser
 */
class JSONWriter extends BaseWriter implements IWriter
{

    /**
     * Получить содержимое документа в виде строки
     *
     * @return  string  Content of document
     */

    public function saveString(): string
    {
        // Фильтруем только непустые строки
        $filteredTable = array_filter($this->table);

        // Преобразуем отфильтрованные данные в JSON
        return json_encode(array_values($filteredTable), JSON_UNESCAPED_UNICODE | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT);
    }

//    public function saveString(): string
//    {
//        $json = array();
//        foreach ($this->table as $row) {
//            if (!empty($row))
//                $json[] = $row;
//        }
//
//        return json_encode($json, JSON_UNESCAPED_UNICODE|JSON_NUMERIC_CHECK|JSON_PRETTY_PRINT);
//    }
}