<?php

namespace Mnv\Models;

use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Core\Model;
use Mnv\Http\Request;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class AdvertisingBanners
 * @package Mnv\Models
 */
class AdsBanner extends Model
{

    /** @var string */
    protected string $table = 'ads_banners';
    /** @var string  */
    protected string $primaryKey = 'bannerId';

    /** @var string  */
    protected string $orderBy = 'bannerId ASC';


    public function __construct(Request $request)
    {
        $this->id   = $request->get('id');
        $this->data = $request->get('banner');
    }

    public function prepare(array $data, int $managerId): bool
    {

        if (empty($this->id)) {

            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }

    /**
     * Удаление баннера
     * @return bool
     * @throws NotFoundException
     * @throws NoContentException
     * @throws DatabaseException
     */
    public function remove(): bool
    {
        if (empty($this->id)) {
            throw new NotFoundException("Not Found: ID is required.");
        }

        $currentRecord = connect($this->table)->select('fileUrl')->where($this->primaryKey, $this->id)->get('array');

        // Throw exception if no record is found for the given `id`
        if (!$currentRecord) {
            throw new NoContentException("No Content: Record not found for the given ID.");
        }

        @unlink(SITE_ROOT . '/' . $currentRecord['fileUrl']);
        $deleted = connect($this->table)->where($this->primaryKey, $this->id)->delete();
        if (!$deleted) {
            throw new DatabaseException("Error: Failed to delete record with ID {$this->id}.");
        }

        return true;

    }


    public function checkFileName(?string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }

}