<?php

namespace Mnv\Models\Cars;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class CarTypes
 * @package Mnv\Models\Cars
 */
class CarTypes extends Model
{
    protected string $table = 'car_types';

    protected string $primaryKey = 'typeId';

    protected string $orderBy = 'orderBy ASC';

    /** @var array|mixed  */
    public $typeIds = [];

    /** @var array|mixed  */
    public $params = [];

    public function __construct(Request $request)
    {
        $this->id             = $request->get('id');
        $this->data           = $request->get('vehicle');
        $this->typeIds     = $request->get('typeIds');
        /** Спецификации */
        $this->params = $request->get('params');
    }

    private function sortBy()
    {
        if (!empty($this->filter['query'])) {
            connect()->grouped(function($q) {
                $q->like('name', "%" . $this->filter['query'] . "%");
            });
        }
        if (!empty($this->filter['status'])) {
            connect()->where('status', $this->filter['status']);
        }

        connect()->whereNull('parentId',  false);

    }


    public function all($limit, $page)
    {
        $this->sortBy();

        return parent::all($limit, $page);
    }
    public function total(): void
    {
        $this->sortBy();

        parent::total();
    }


    public function prepare(array $data, int $managerId): bool
    {
        $data['modifiedBy']   = $managerId;
        $data['modifiedOn']   = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {

            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = connect($this->table)->max('orderBy')->getValue() + 1;
            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }


    /**
     * Удаление
     *
     * @return bool
     */
    public function remove(): bool
    {
        /** удаление свойства */
        if (connect()->table($this->table)->where($this->primaryKey, $this->id)->delete()) {
            /** СПЕЦИФИКАЦИЯ */
            if (connect()->table($this->table)->select($this->primaryKey)->where($this->primaryKey, $this->id)->getAll()) {
                /** удаление спецификации */
                connect()->table($this->table)->where('parentId', $this->id)->delete();

            }

            return true;
        }

        return false;
    }


    public function checkFileName(string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }


    /** SPECIFICATIONS */

    /**
     * Функция возвращает варианты товара
     * @return array|null
     */
    public function bodyTypes(int $typeId): ?array
    {
        if (!empty($typeId)) {
            return connect($this->table)->where('parentId', $typeId)->orderBy('orderBy')->indexKey($this->primaryKey)->getAllIndexes('array');
        }

        return [];
    }

    public function bodyType(int $typeId)
    {
        if (!empty($typeId)) {
            return connect($this->table)->where($this->primaryKey, $typeId)->get('array');
        }

        return null;
    }

    public function addBodyType(array $type): int
    {
        $type['parentId'] = $this->id;
        $type['orderBy'] = 0;

        return connect($this->table)->insert($type);
    }

    /**
     * @param int $typeId
     * @param array $type
     */
    public function updateBodyType(int $typeId, array $type): void
    {
        connect($this->table)->where($this->primaryKey, $typeId)->update($type);
    }

    public function removeBodyType(int $typeId): void
    {
        connect($this->table)->where($this->primaryKey, $typeId)->delete();
    }



//    public function getVehicle($typeId): ?string
//    {
//        return connect('car_vehicles')->select('name')->where('typeId', $typeId)->getValue();
//    }
//
//    /**
//     * Получение всех типов автотранспорта
//     *
//     * @return array|null
//     */
//    public function getVehicles(): ?array
//    {
//        $vehicles = array('0' => 'Выберите тип автотранспорта...');
//        if ($types = connect('car_vehicle_types')->select('*')->orderBy('orderBy ASC')->indexKey('typeId')->getAllIndexes('array')) {
//            foreach ($types as $typeId => $type) {
//                $vehicle = connect()->table('car_vehicles')->select('name')->where('vehicleId', $type['vehicleId'])->getValue();
//                if (!empty($type['name'])) {
//                    $vehicles[$vehicle][$typeId] = $type['name'];
//                }
//            }
//        }
//
//        return $vehicles ?? [];
//    }

}