<?php


namespace Mnv\Models\Cars;


use Mnv\Core\Model;
use Mnv\Http\Request;

class Modifications extends Model
{
    /** @var string  */
    protected string $table = 'car_modifications';

    /** @var string  */
    protected string $primaryKey = 'modificationId';

    /** @var string  */
    protected string $orderBy = 'orderBy ASC';

    public $equipmentIds = [];

    public $specifications = [];

    public $modificationIds = [];


    public function __construct(Request $request)
    {
        $this->id              = $request->get('id');
        $this->data            = $request->get('modification');
        $this->specifications  = $request->get('specifications');
        $this->equipmentIds    = $request->get('equipmentIds');
        $this->modificationIds = $request->get('modificationIds');
    }

    /** фильтрация / сортировка */
    protected function sorting(): void
    {
        if (!empty($this->filter['status'])) {
            connect()->where('status', $this->filter['status']);
        }

        if (!empty($this->filter['query'])) {
            connect()->grouped(function($q) {
                $q->like('name', "%" . $this->filter['query'] . "%")->orLike('power', "%" . $this->filter['query'] . "%");
            });
        }

        if (!empty($this->filter['model_id'])) {
            connect()->where('modelId', $this->filter['model_id']);
        }

    }

    /** Получение всех статей */
    public function all($limit, $page)
    {
        /** фильтрация / сортировка */
        $this->sorting();

        return parent::all($limit, $page);
    }

    /** Получение кол-во контента */
    public function total(): void
    {
        /** фильтрация / сортировка */
        $this->sorting();
        parent::total();
    }

    public function prepare(array $data, int $managerId): bool
    {

        $data['modifiedBy']   = $managerId;
        $data['modifiedOn']   = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {

            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = connect($this->table)->max('orderBy')->getValue() + 1;
            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {

            return $this->update($data);
        }

        return false;
    }

    public function checkFileName(string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }



    /**
     * ПОЛУЧИТЬ все свойства, спецификации и ех значения
     * @return array|null
     */
    public function getFeaturesSpecificationsValues(): ?array
    {
        if ($features = connect('car_specifications')->select('specificationId, name')->where('status', 'V')->orderBy('orderBy')->whereNull('parentId',  false)->keyBy('specificationId')) {
            foreach ($features as $featureId => &$feature) {
                $specifications = connect('car_specifications')->select('specificationId, name')->where('parentId', $feature['specificationId'])->orderBy('orderBy ASC')->whereNull('parentId',  true)->getAll('array');
                if (!empty($specifications)) {
                    foreach ($specifications as &$specification) {
                        $values = connect()->table('car_specifications_value')->select('value, unit')->where('specificationId', $specification['specificationId'])->where('modificationId', $this->id)->get('array');
                        $specification['value'] = !empty($values) ? $values['value'] : '';
                        $specification['unit'] = !empty($values) ? $values['unit'] : '';
                    }
                }
                $features[$featureId]['specifications'] = $specifications;
            }
        }
//        print_r($features);


        return $features;
    }


    /**
     * Обновление параметров спецификации
     *
     * @param $specifications
     */
    public function updateSpecifications($specifications): void
    {
        if (!empty($this->id)) {
            connect()->table('car_specifications_value')->where('modificationId', $this->id)->delete();
        }

        foreach ($specifications as $specificationId => $specification) {
            connect()->table('car_specifications_value')->insert([
                'specificationId'   => $specificationId,
                'modificationId'    => $this->id,
                'value'             => $specification['value'],
                'unit'              => $specification['unit'],
            ]);
        }
    }

    public function getModel($modelId): ?string
    {
        return connect('car_models')->select('title')->where('modelId', $modelId)->getValue();
    }

    public static function getSelectModifications(): ?array
    {
        $modifications = array('0' => 'Выберите модификацию...');
        $result = connect()->table('car_modifications')->select('*')->orderBy('orderBy ASC')->pluck('name', 'modificationId');
        if (!empty($result)) {
            $modifications += $result;
        }

        return $modifications;
    }

    public static function getModification($modificationId): ?string
    {
        return connect('car_modifications')->select('name')->where('modificationId', $modificationId)->getValue();

    }

}