<?php

namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class FAQ
 * @package Mnv\Models
 */
class FAQ extends Model
{
    /** @var string */
    protected string $table = 'faq';
    /** @var string  */
    protected string $primaryKey = 'faqId';

    /** @var string  */
    protected string $orderBy = 'orderBy ASC';

    public $faqIds = [];


    public function __construct(Request $request)
    {
        $this->id       = $request->get('id');
        $this->data     = $request->get('faq');
        $this->faqIds   = $request->get('ids');
    }


    public function prepare(array $data, int $managerId): bool
    {
        $data['modifiedBy']    = $managerId;
        $data['modifiedOn']    = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {

            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = $this->getMaxValue('orderBy') + 1;
            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }


    public function checkFileName(?string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }

}