<?php

namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class Maps
 * @package Mnv\Models
 */
class Maps extends Model
{

    /** @var string */
    protected string $table = 'maps';

    protected string $columns = 'codename, value';

    public function __construct(Request $request)
    {
        $this->data = $request->get('map');
    }

    public function edit(): Maps
    {
        $this->data = connect($this->table)->select($this->columns)->pluck('value', 'codename');

        return $this;
    }


    public function prepare(array $data, int $managerId): bool
    {
        foreach ($data as $codename => $value) {
            $params = [
                'codename'  => $codename,
                'value'     => $value,
            ];

            connect($this->table)->replace($params);
        }

        return true;
    }

    public function checkFileName(string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }
}