<?php

namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Core\Collections\Collection;
use Mnv\Http\Request;

/**
 * Class Orders
 * @package Mnv\Models
 */
class Orders extends Model
{

    /** @var string */
    protected string $table = 'shop_orders';

    /** @var string */
    protected string $primaryKey = 'order_id';

    protected string $orderBy = 'order_id DESC';

    /** @var string  */
    protected string $columns = '*';

    public $product;
    public $product_id;


    public function __construct(Request $request)
    {
        $this->id   = $request->get('id');
        $this->data = $request->get('order');
        $this->product = $request->get('product');
        $this->product_id = $request->get('product_id');
    }

    public function orderStatuses()
    {
       return connect('shop_order_status')->select('*')->pluck('name','order_status_id');
    }

    /** фильтрация / сортировка контента */
    protected function sorting(): void
    {

        if (!empty($this->filter['status'])) {
            connect()->where('status', $this->filter['status']);
        }

        if (!empty($this->filter['query'])) {
            connect()->grouped(function($q) {
                $q->like('title', "%" . $this->filter['query'] . "%")->orLike('content', "%" . $this->filter['query'] . "%")->orLike('keywords',"%" . $this->filter['query'] . "%");
            });
        }


        if (!empty($this->filter['dateStart']) && !empty($this->filter['dateEnd'])) {
            connect()->between('createdBy', $this->filter['dateStart'], $this->filter['dateEnd']);
        }
    }

    public function all($limit, $page)
    {
        $this->sorting();
        return  parent::all($limit, $page);
    }

    public function total(): void
    {
        $this->sorting();
        parent::total();
    }


    public function edit(): Orders
    {
        global $SECTIONS;

        $data = [];
        if (!empty($this->id)) {
            $order_info = $this->getOrder($this->id);
            if (!empty($order_info)) {
                $data['order_id']   = $this->id;
//                $data['order_id']   = $order_info['order_id'];
                $data['userId']     = $order_info['userId'];
                $data['fullName']   = $order_info['fullName'];
                $data['firstName']  = $order_info['firstName'];
                $data['lastName']   = $order_info['lastName'];
                $data['email']      = $order_info['email'];
                $data['phone']      = $order_info['phone'];
                $data['address']    = $order_info['address'];
                $data['createdBy']  = $order_info['createdBy'];
                $data['payment_choice']  = $order_info['payment_choice'];
                $data['payment_method']  = $order_info['payment_method'];
                $data['shipping_zone']  = $order_info['shipping_zone'];
                $data['shipping_date']  = $order_info['shipping_date'];
                $data['shipping_method']  = $order_info['shipping_method'];
                $data['shipping_coordinates']  = $order_info['shipping_coordinates'];
                $data['status'] = $order_info['status'];
                $data['state'] = $order_info['state'];
                $data['shipping_amount'] = $order_info['shipping_amount'];
                $data['products_amount'] = $order_info['products_amount'];
                $data['amount'] = $order_info['amount'];
                $data['message'] = $order_info['message'];
                $data['order_status_id'] = $order_info['order_status_id'];

                $products = $this->getOrderProducts($this->id);
                foreach ($products as $product) {
                    $data['products'][] = array(
                        'product_id' => $product['product_id'],
                        'name'       => $product['name'],
                        'sku'        => $product['sku'],
                        'ikpu'       => $product['ikpu'],
                        'brand'      => connect('brands')->select('name')->where('fileName', $product['brand'])->getValue(),
                        'option'     => $this->getOrderOptions($this->id, $product['order_product_id']),
                        'quantity'   => $product['quantity'],
                        'price'      => $product['price'],
                        'total'      => $product['total'],
                    );
                }

                $data['totals'] = $this->getOrderTotals($this->id);
            }
        }

        $this->data = $data;

        return $this;
    }


    public function prepare(array $data, int $managerId): bool
    {
        $this->addOrderHistory($this->id, $data['order_status_id']);

        if ($this->update($data)) {
            return true;
        }

        return false;

    }

    /**
     * Удаление
     *
     * @return bool
     *
     * @throws Exceptions\NoContentException
     * @throws Exceptions\NotFoundException
     * @throws \Mnv\Core\Database\Throwable\DatabaseException
     */
    public function remove(): bool
    {
        if (parent::remove()) {
            $product = connect('shop_order_product')->select('*')->where('order_id', $this->id)->where('product_id', $this->product_id)->get('array');
            if (!empty($product)) {
                if (connect('shop_order_product')->select('*')->where('order_id', $this->id)->where('product_id', $this->product_id)->delete()) {
                    connect('shop_order_option')->select('*')->where('order_id', $this->id)->where('order_product_id', $product['order_product_id'])->delete();
                    connect('shop_order_total')->where('order_id', $this->id)->delete();
                    return true;
                }
            }
        }


        return false;
    }

    public function editCartProducts($product_id, $quantity = 1, $option = array())
    {
        $newTotalPrice = 0;
        $product = connect('shop_order_product')->select('*')->where('order_id', $this->id)->where('product_id', $product_id)->get('array');
        if ($product) {
            $newTotalPrice = $product['price'] * $quantity;
            connect('shop_order_product')->select('*')->where('order_id', $this->id)->where('product_id', $product_id)->update([
                'quantity'   => $quantity,
                'total'      => $newTotalPrice
            ]);
        }


       return $newTotalPrice;

    }
    // TODO: доделать обновление в `shop_order_total`
    public function updateTotals($totalPrice)
    {
        $shipping_amount = connect('shop_orders')->select('shipping_amount')->where('order_id', $this->id)->getValue();
        $total_amount = $totalPrice + $shipping_amount;

        $totals[] = $this->sub_total($totalPrice);
        if (!empty($shipping_amount)) {
            $totals[] = $this->shipping($shipping_amount);
        }
        $totals[] = $this->total_amount($total_amount);

        // Totals
        if (isset($totals)) {
            foreach ($totals as $total) {
                connect('shop_order_total')->where('order_id', (int)$this->id)->where('code', $total['code'])->update(['value' => $total['value']]);
            }
        }
    }


    /** предварительная сумма (сумма за товар) */
    private function sub_total($products_amount): array
    {
        return array(
            'code'       => 'sub_total',
            'title'      =>  'Сумма',
            'value'      => $products_amount,
            'sort_order' => 1
        );
    }
    /** сумма за доставку */
    private function shipping($shipping_amount): array
    {
        return array(
            'code'       => 'shipping',
            'title'      =>  'Стоимость доставки',
            'value'      => $shipping_amount,
            'sort_order' => 2
        );
    }
    /** итого к оплате */
    private function total_amount($total_amount): array
    {
        return array(
            'code'       => 'total',
            'title'      => 'Итого',
            'value'      => $total_amount,
            'sort_order' => 2
        );

    }


    public function getOrder($order_id)
    {
        return connect($this->table)->select('*')->where('order_id', $order_id)->get('array');
    }

    public function getOrderTotals($order_id)
    {
        return connect('shop_order_total')->select('*')->where('order_id', $order_id)->orderBy('sort_order')->getAll('array');
    }
    public function getOrderProducts($order_id)
    {
        return connect('shop_order_product')->select('*')->where('order_id', $order_id)->getAll('array');
    }

    public function getOrderOptions($order_id, $order_product_id)
    {
        return connect('shop_order_option')->select('*')->where('order_id', $order_id)->where('order_product_id', $order_product_id)->getAll('array');
    }

    private function addOrderHistory(int $order_id, int $order_status_id)
    {
        if (!empty($order_id)) {
            $order_info = $this->getOrder($order_id);

            if ($order_info) {

                // Если текущий статус заказа обрабатывается или завершен, но новый статус - обрабатывается или завершен, то приступайте к выполнению заказа
                if (in_array($order_status_id, [5])) {

                    // Stock subtraction
                    $order_products = $this->getOrderProducts($order_id);
                    foreach ($order_products as $order_product) {
                        $quantity = connect('products')->select('quantity')->where('productId', $order_product['product_id'])->getValue();
                        $stock_status_id = 0;
                        $newQuantityProduct = $quantity - $order_product['quantity'];
                        if ($newQuantityProduct <= 0) $newQuantityProduct = 0;
                        if ($newQuantityProduct == 0) $stock_status_id = 1;
                        connect('products')->where('productId', $order_product['product_id'])->where('subtract', 1)->update(['quantity' => $newQuantityProduct, 'stock_status_id' => $stock_status_id]);

                        // опции
                        $order_options = $this->getOrderOptions($order_id, $order_product['order_product_id']);
                        if ($order_options) {
                            foreach ($order_options as $order_option) {
                                $quantity = connect('product_option_value')->select('quantity')->where('product_option_value_id', $order_option['product_option_value_id'])->getValue();
                                $newQuantityOption = $quantity - (int)$order_product['quantity'];
                                if ($newQuantityOption <= 0) $newQuantityOption = 0;
                                connect('product_option_value')->where('product_option_value_id', (int)$order_option['product_option_value_id'])->where('subtract', 1)->update(['quantity' => $newQuantityOption]);
                            }
                        }
                    }
                }

//            connect($this->table)->where('order_id', $order_id)->update(['modifiedOn' => gmdate('Y-m-d H:i:s'), 'order_status_id' => $order_status_id]);

            }
        }
    }

//    public function removeCartProduct()
//    {
//       $product = connect('shop_order_product')->select('*')->where('order_id', $this->id)->where('product_id', $this->product_id)->get('array');
//       if (!empty($product)) {
//           if (connect('shop_order_product')->select('*')->where('order_id', $this->id)->where('product_id', $this->product_id)->delete()) {
//               connect('shop_order_option')->select('*')->where('order_id', $this->id)->where('order_product_id', $product['order_product_id'])->delete();
//               return true;
//           }
//       }
//
//       return false;
//    }


}