<?php

namespace Mnv\Models\Shop;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class Coupons
 * @package Mnv\Models\Shop
 */
class Coupons extends Model
{

    /** @var string */
    protected string $table = 'coupons';
    /** @var string  */
    protected string $primaryKey = 'couponId';

    protected string $orderBy = 'couponId ASC';

    public function __construct(Request $request)
    {
        $this->id   = $request->get('id');
        $this->data = $request->get('coupon');
    }

    public function prepare(array $data, int $managerId): bool
    {
        if (empty($this->id)) {
            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }


    /**
     * Сортировка слайдов
     *
     * @param $couponIds
     */
    public function reorder($couponIds): void
    {
        $i = 0;
        foreach ($couponIds as $couponId) {
            $i++;
            connect()->table($this->table)->where($this->primaryKey, $couponId)->update(['orderBy' => $i]);
        }
    }


    public function checkFileName(?string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }

}