<?php


namespace Mnv\Modules\Cars;

/**
 * Class Stations
 * @package Mnv\Modules\Cars
 */
class Stations
{
    /** @var array  */
    public $stations = [];

    /** @var int */
    private $section;

    public function __construct($section)
    {
        $this->section = $section;
    }

    public function all()
    {
        $this->stations['type'] = "FeatureCollection";

        $stations = connect('articles')->select('articleId, title, alias')->where('sectionId', $this->section)->where('typeContent', 'stations')->orderBy('publishedOn DESC')->limit(1000)->getAll('array');
        foreach ($stations as $stationId => $station) {
            $param = $this->getProperties($station['articleId']);
            if (!empty($param['coordinates'])) {
                $this->stations['features'][$stationId]['id'] = $station['articleId'];
                $this->stations['features'][$stationId]['type'] = "Feature";
                $this->stations['features'][$stationId]['geometry']['type'] = "Point";
                $this->stations['features'][$stationId]['geometry']['coordinates'] = explode(", ", $param['coordinates']);
                $this->stations['features'][$stationId]['properties']['balloonContent'] = $station['title'];
                $this->stations['features'][$stationId]['properties']['id'] = $station['articleId'];
            }
        }
    }

    private function getProperties($articleId): array
    {
        if ($result = connect()->table('type_content_field_data')
            ->usingJoin('type_content_fields', 'fileName')
            ->select('articleId, typeId, type, fieldId, fileName, name, value, orderBy')
            ->where('articleId', $articleId)
            ->where('status', 'V')
            ->orderBy('orderBy')
            ->indexKey('fileName')->valueKey('value')->getAllIndexes('array')
        ) {


            return $result;
        }

        return array();
    }
}