<?php

namespace Mnv\Modules;

use Mnv\Core\ConfigManager;
use Mnv\Core\Utilities\Cookie\Cookie;

class Compares
{
    /**
     * Текущий список ID новостей закладок
     * @var array
     */
    private $list = [];

    public $countCompares = 0;

    /**
     * Конструктор класса
     */
    public function __construct()
    {
        $this->loadConfig();
        $this->loadList();
    }


    /**
     * Добавление/удаление новости в закладки
     * @param  integer $id ID новости
     * @return string текст ошибки
     */
    public function setId($id = 0)
    {
        global $userAuth;
        $id = (int)$id;
        if ($id < 1) {
            return 'Не задан ID';
        }

        if (!$userAuth->checkUser() && !ConfigManager::getValue('allow_guest')) {
            return 'Гости не могут использовать закладки';
        }

        if (isset($this->list[$id])) {
            unset($this->list[$id]);
            $list = array_keys($this->list);
        } else {
            $list = array_keys($this->list);
            array_unshift($list, $id);
        }

        if (ConfigManager::getValue('limit')  > 0 && count($list) > ConfigManager::getValue('limit')) {
            return 'Вы можете сохранить не более ' . ConfigManager::getValue('limit') . ' ';
        }
        $this->countCompares = count($list);

        $list = join(',', $list);

        if ($userAuth->checkUser()) {
            connect()->table('users')->where('userId',  $userAuth->id())->update(['compares' => $list]);
        } else {
            Cookie::setcookie('_compares', $list, \time() + 3600 * 24 * 1000, "/");
        }
    }

    /**
     * Получение текущего массива ID закладок
     * @return array
     */
    public function getList()
    {
        $list = array_keys($this->list);
        if (!$list) {
            $list[] = 0;
        }
        return $list;
    }


    /**
     * Проверка является ли избранной
     * @param  array  $m
     * @return bool
     */
    private function isCompares($m = [])
    {
        return $this->list[$m[2]] ? $m[3] : '';
    }


    /**
     * Получение конфига
     * @return void
     */
    private function loadConfig()
    {

        ConfigManager::init()->set('limit', 100);
        ConfigManager::init()->set('allow_guest', true);
    }


    /**
     * Получение списка закладок
     * @return void
     */
    private function loadList()
    {
        global $userAuth;
//        if (!$is_logged && !ConfigManager::getValue('allow_guest')) {
//            return;
//        }

        $list = $userAuth->checkUser() ? connect()->table('users')->select('compares')->where('userId', $userAuth->id())->getValue() : Cookie::get('_compares');
        $list = $list ? explode(',', $list) : [];
        if ($list) {
            foreach ($list as $v) {
                $v = (int)$v;
                if ($v > 0) {
                    $this->list[$v] = true;
                }
            }
            if ($this->list && ConfigManager::getValue('limit') > 0) {
                $this->list = array_slice($this->list, 0, ConfigManager::getValue('limit'), true);
            }
        }
    }
}