<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        https://life-style.uz/                              //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

function smarty_function_fetch_banners($params, &$smarty) {

    $assign   = fetch_getParam('assign', $params, 'banners');
    $fields   = fetch_getParam('fields', $params, 'bannerId, title, alias, text, summary, url, fileId, orderBy');
    $status   = fetch_getParam('status', $params, 'V');
    $order    = fetch_getParam('order', $params, 'orderBy ASC');
    $orderBy  = fetch_getParam('orderBy', $params, $order);

    $section  = (int)fetch_getParam('section', $params);
    $limit    = (int) fetch_getParam('limit', $params,  10);

    $image        = fetch_getParam('getImage', $params, true);
    $imageType    = fetch_getParam('imageType', $params, 'general');

    $banners = connect('banners')
        ->usingJoin('banner_sections', 'bannerId')
        ->select($fields)
        ->where('sectionId', $section)
        ->where('status', $status)
        ->orderBy($orderBy)
        ->limit($limit)
        ->keyBy('bannerId');

    if (!empty($banners)) {
        $banners = prepareBanners($banners, $image, $imageType);
    }

//    print_r($banners);
    $smarty->assign($assign, $banners);

}