<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

//use Mnv\Modules\Cars\Dealers;

function smarty_function_fetch_dealers($params, &$smarty){

	$assign        = fetch_getParam('assign', $params, 'dealers');
    $fields        = fetch_getParam('fields', $params, 'dealerId, cityId, publishedOn, title, content, coordinates, address, office_hours, phone, landmark, website');
    $cityId        = (int) fetch_getParam('city', $params);
    $orderBy       = fetch_getParam('order', $params, 'publishedOn DESC');
    $limit         = (int) fetch_getParam('limit', $params, 1000);

	/* conditions */
    if ($cityId) {
        connect()->where('cityId', $cityId);
    }
    $dealers = connect('dealers')->select($fields)->orderBy($orderBy)->limit($limit)->keyBy('dealerId');
    $dealers = prepareDealers($dealers);

    if (!empty($dealers)) {
        $dealers = collect($dealers)->map(function($dealer) {
            if (!empty($dealer['coordinates'])) {
                $dealer['mapUrl'] = generateMapUrl($dealer);
            }
            return $dealer;
        })->all();
    }

//	print_r($dealers);
	$smarty->assign($assign, $dealers);

	return null;
}

function generateMapUrl(array $dealer): string
{
    $coordinates = !empty($dealer['coordinates'])
        ? explode(',', $dealer['coordinates'])
        : [];

    if (count($coordinates) !== 2) {
        return ''; // Возвращаем пустую строку, если координаты некорректны.
    }

    $coordinates = implode(',', array_reverse($coordinates));

    return "https://yandex.ru/maps/?ll={$coordinates}&z=16&pt={$coordinates}&mode=search&text={$dealer['title']}&source=constructor";
}

?>