<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Modules\Cars\Model;

function smarty_function_fetch_models($params, &$smarty) {

	$assign        = fetch_getParam('assign', $params, 'models');
//    $fields        = fetch_getParam('fields', $params, 'cm.sectionId, cm.modelId, cm.title, cm.alias, cm.fileName, cm.url, cm.summary, cm.paymentMethods, MIN(NULLIF(ce.oldPrice, "0.00")) AS minOldPrice, MIN(NULLIF(ce.price, "0.00")) AS minPrice, MIN(NULLIF(ce.monthPay, "0.00")) AS minMonthPay');
    $fields        = fetch_getParam('fields', $params, 'cm.sectionId, cm.modelId, cm.title, cm.alias, cm.fileName, cm.url, cm.summary, cm.paymentMethods');
	$status        = fetch_getParam('status', $params, 'V');
	$limit         = (int) fetch_getParam('limit', $params);
	$perPage       = (int) fetch_getParam('perPage', $params, $limit);

    $getImage     = fetch_getParam('getImage', $params, true);
    $imageType    = fetch_getParam('imageType', $params, 'general');

	
	$query         = fetch_getParam('query', $params, NULL);
	$order         = fetch_getParam('order', $params, NULL);
	$section       = fetch_getParam('section', $params);
	$test_drive    = fetch_getParam('test_drive', $params);
//	$special    = fetch_getParam('special', $params, NULL);

	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_models: "assign" must not be empty');
		return;
	}

    if (!empty($section)) {
        if (is_array($section)) {
            connect()->in('cm.sectionId', $section);
        } else {
            connect()->where('cm.sectionId', $section);
        }
    }

	if (!empty($test_drive)) {
	    connect()->where('test_drive', $test_drive);
    }

	if (!empty($status)) connect()->where('cm.status', $status);
//	if (!empty($special)) connect()->where('special', $special);

	if (!empty($order)) {
	    connect()->orderBy($order);
    }

//    $models = connect('car_models AS cm')
//        ->leftJoin('car_equipments AS ce', 'ce.modelId', '=', 'cm.modelId')
//        ->select($fields)->where('ce.status', 'V')
//        ->groupBy('cm.modelId')
//        ->keyBy('modelId');

    $models = connect('car_models AS cm')->select($fields)->keyBy('modelId');


//    print_r(connect()->getQuery());
    $models = prepareModels($models, $getImage, $imageType);
    $newModels = collect($models)->map(function ($model, $modelId) {
        $model += connect('car_equipments')
            ->select("MIN(NULLIF(oldPrice, '0.00')) AS minOldPrice, MIN(NULLIF(price, '0.00')) AS minPrice, MIN(NULLIF(monthPay, '0.00')) AS minMonthPay")
            ->where('status', 'V')
            ->where('modelId', $modelId)
            ->get('array');

        if (!empty($model['paymentMethods'])) {
            $model['paymentMethods'] = json_decode($model['paymentMethods'], true);
            if (is_array($model['paymentMethods'])) {
                $paymentMethodNames = connect('car_deal_types')->whereIn('fileName', array_keys($model['paymentMethods']))->pluck('name', 'fileName');
                foreach ($model['paymentMethods'] as $filename => $value) {
                    $model['paymentMethods'][$filename] = $paymentMethodNames[$filename] ?? null;
                }
            }
        }

        return $model;
    })->all();

// SELECT MIN(oldPrice) AS minOldPrice FROM ls_car_equipments WHERE status = 'V' AND NOT oldPrice = '0.00' AND modelId = 3 LIMIT 1;
// SELECT MIN(price) AS minPrice FROM ls_car_equipments WHERE status = 'V' AND NOT price = '0.00' AND modelId = 3 LIMIT 1;
// SELECT MIN(monthPay) AS minMonthPay FROM ls_car_equipments WHERE status = 'V' AND NOT monthPay = '0.00' AND modelId = 3 LIMIT 1;
//	print_r($newModels);
	$smarty->assign($assign, $newModels);

	
	return null;
}


?>