function ansverCreate(arg) {
    const iconTmpSuccess = `
        <svg xmlns="http://www.w3.org/2000/svg" width="120" height="124" viewBox="0 0 120 124" fill="none">
            <path d="M73.1878 60.7016C60.6787 83.3273 53.9733 102.279 53.9733 102.279C39.5003 76.3131 14.2646 66.5473 14.2646 66.5473C35.4294 65.7642 50.7847 77.043 50.7847 77.043C65.0904 50.65 88.0035 24.4075 104.477 15.4109C104.477 15.4109 85.1676 39.0334 73.1878 60.7016Z" fill="url(#paint0_linear_325_2739)"/>
            <path d="M118.264 49.1391C116.77 43.0617 114.332 37.2158 111.074 31.8653L107.706 33.9689C110.819 38.9288 113.178 44.3695 114.659 50.052C116.121 55.7336 116.708 61.6492 116.402 67.5266C115.792 79.2444 111.478 90.9623 104.132 100.122C102.294 102.432 100.303 104.623 98.141 106.638C95.9686 108.641 93.6526 110.486 91.2142 112.157L89.3582 113.369C74.7557 122.909 56.5465 123.942 40.2223 118.917C39.5116 118.698 38.8239 118.415 38.1303 118.148C33.2656 116.262 28.6927 113.709 24.4919 110.611C22.1004 108.828 19.86 106.846 17.7583 104.725C11.4173 98.3292 6.80851 90.4142 3.87875 81.9184C2.96546 79.0618 2.24207 76.1418 1.7522 73.177C1.29333 70.2083 1.03476 67.2084 0.991378 64.1998C0.942293 58.1844 1.80773 52.1559 3.58027 46.3969C5.34834 40.637 8.01804 35.1513 11.4577 30.1946C14.8952 25.2362 19.0997 20.8067 23.8791 17.113C25.7104 15.6966 27.6267 14.3895 29.6134 13.1987C37.6406 8.67217 44.581 6.79399 46.6835 6.97658C46.6835 6.97658 35.3309 10.3078 28.2923 17.2016C28.2923 17.2016 31.8314 22.6961 38.8596 21.3726C47.1496 19.8129 48.0421 11.2255 59.1086 6.489C59.1086 6.489 51.0938 -1.45905 40.5156 0.23753C34.2361 1.24503 26.9973 6.93429 26.737 13.7654C26.7213 14.1166 26.731 14.456 26.76 14.7848C25.7285 15.4632 24.7168 16.1724 23.7294 16.915C18.8798 20.5579 14.5873 24.9554 11.0529 29.9075C7.51653 34.8577 4.74121 40.3634 2.87125 46.1721C0.996832 51.9797 0.0332195 58.0859 0 64.2016C0.00223116 67.2601 0.223364 70.3172 0.650259 73.3492C1.10814 76.3772 1.80501 79.3663 2.69846 82.297C5.31784 90.8884 10.2725 99.3335 16.6038 105.853C18.7236 108.051 20.9895 110.113 23.4143 111.975C28.2346 115.678 33.7644 118.914 39.5666 120.795C57.4714 126.598 76.7724 124.546 92.7265 114.434C95.3039 112.72 97.758 110.819 100.066 108.749C102.363 106.666 104.487 104.394 106.452 101.991C108.426 99.5944 110.175 97.0132 111.744 94.3296C112.551 92.9994 113.242 91.6041 113.949 90.218C117.39 83.4697 119.236 75.3796 119.866 67.7457C120.277 61.5191 119.742 55.2209 118.264 49.1391Z" fill="url(#paint1_linear_325_2739)"/>
                <defs>
                <linearGradient id="paint0_linear_325_2739" x1="14.2645" y1="58.8449" x2="104.477" y2="58.8449" gradientUnits="userSpaceOnUse">
                <stop stop-color="#27ae60"/>
                <stop offset="1" stop-color="#27ae60"/>
                </linearGradient>
                <linearGradient id="paint1_linear_325_2739" x1="0.466288" y1="56.8751" x2="119.75" y2="69.0254" gradientUnits="userSpaceOnUse">
                <stop stop-color="#27ae60"/>
                <stop offset="1" stop-color="#27ae60"/>
                </linearGradient>
                </defs>
        </svg>
    `
    const iconTmpError = `
        <svg xmlns="http://www.w3.org/2000/svg" width="120" height="124" viewBox="0 0 120 124" fill="none">
            <path d="M73.1878 60.7016C60.6787 83.3273 53.9733 102.279 53.9733 102.279C39.5003 76.3131 14.2646 66.5473 14.2646 66.5473C35.4294 65.7642 50.7847 77.043 50.7847 77.043C65.0904 50.65 88.0035 24.4075 104.477 15.4109C104.477 15.4109 85.1676 39.0334 73.1878 60.7016Z" fill="url(#paint0_linear_325_2739)"/>
            <path d="M118.264 49.1391C116.77 43.0617 114.332 37.2158 111.074 31.8653L107.706 33.9689C110.819 38.9288 113.178 44.3695 114.659 50.052C116.121 55.7336 116.708 61.6492 116.402 67.5266C115.792 79.2444 111.478 90.9623 104.132 100.122C102.294 102.432 100.303 104.623 98.141 106.638C95.9686 108.641 93.6526 110.486 91.2142 112.157L89.3582 113.369C74.7557 122.909 56.5465 123.942 40.2223 118.917C39.5116 118.698 38.8239 118.415 38.1303 118.148C33.2656 116.262 28.6927 113.709 24.4919 110.611C22.1004 108.828 19.86 106.846 17.7583 104.725C11.4173 98.3292 6.80851 90.4142 3.87875 81.9184C2.96546 79.0618 2.24207 76.1418 1.7522 73.177C1.29333 70.2083 1.03476 67.2084 0.991378 64.1998C0.942293 58.1844 1.80773 52.1559 3.58027 46.3969C5.34834 40.637 8.01804 35.1513 11.4577 30.1946C14.8952 25.2362 19.0997 20.8067 23.8791 17.113C25.7104 15.6966 27.6267 14.3895 29.6134 13.1987C37.6406 8.67217 44.581 6.79399 46.6835 6.97658C46.6835 6.97658 35.3309 10.3078 28.2923 17.2016C28.2923 17.2016 31.8314 22.6961 38.8596 21.3726C47.1496 19.8129 48.0421 11.2255 59.1086 6.489C59.1086 6.489 51.0938 -1.45905 40.5156 0.23753C34.2361 1.24503 26.9973 6.93429 26.737 13.7654C26.7213 14.1166 26.731 14.456 26.76 14.7848C25.7285 15.4632 24.7168 16.1724 23.7294 16.915C18.8798 20.5579 14.5873 24.9554 11.0529 29.9075C7.51653 34.8577 4.74121 40.3634 2.87125 46.1721C0.996832 51.9797 0.0332195 58.0859 0 64.2016C0.00223116 67.2601 0.223364 70.3172 0.650259 73.3492C1.10814 76.3772 1.80501 79.3663 2.69846 82.297C5.31784 90.8884 10.2725 99.3335 16.6038 105.853C18.7236 108.051 20.9895 110.113 23.4143 111.975C28.2346 115.678 33.7644 118.914 39.5666 120.795C57.4714 126.598 76.7724 124.546 92.7265 114.434C95.3039 112.72 97.758 110.819 100.066 108.749C102.363 106.666 104.487 104.394 106.452 101.991C108.426 99.5944 110.175 97.0132 111.744 94.3296C112.551 92.9994 113.242 91.6041 113.949 90.218C117.39 83.4697 119.236 75.3796 119.866 67.7457C120.277 61.5191 119.742 55.2209 118.264 49.1391Z" fill="url(#paint1_linear_325_2739)"/>
                <defs>
                <linearGradient id="paint0_linear_325_2739" x1="14.2645" y1="58.8449" x2="104.477" y2="58.8449" gradientUnits="userSpaceOnUse">
                <stop stop-color="#eb4d4b"/>
                <stop offset="1" stop-color="#eb4d4b"/>
                </linearGradient>
                <linearGradient id="paint1_linear_325_2739" x1="0.466288" y1="56.8751" x2="119.75" y2="69.0254" gradientUnits="userSpaceOnUse">
                <stop stop-color="#eb4d4b"/>
                <stop offset="1" stop-color="#eb4d4b"/>
                </linearGradient>
                </defs>
        </svg>
    `
    const { form, status } = arg
    const formNode = document.querySelector(`#${form}`)
    const ansver = document.createElement('div'),
        ansverText = document.createElement('div'),
        ansverTitle = document.createElement('h3'),
        ansverP = document.createElement('p')


    ansver.classList.add('ansver-form')
    ansverText.classList.add('text-tmp', 'title-36', 'all-center')
    ansverTitle.textContent = formNode.getAttribute('data-title')
    ansverP.textContent = formNode.getAttribute('data-massege')

    ansverText.insertAdjacentElement('beforeend', ansverTitle)
    ansverText.insertAdjacentElement('beforeend', ansverP)
    ansver.insertAdjacentElement('beforeend', ansverText)
    if (status != 200) {
        ansver.insertAdjacentHTML('beforeend', iconTmpError)
    } else {
        ansver.insertAdjacentHTML('beforeend', iconTmpSuccess)
    }
    formNode.insertAdjacentElement('beforeend', ansver)
}

export const form = () => {
    let feedback = new Validations(['#call_me', '#special_offer', '#feedback', '#booking'])

    // Функция для обработки формы с улучшением производительности
    async function submitFormHandler(form) {
        // Создаём AbortController для возможности отмены устаревших запросов
        const controller = new AbortController();
        const signal = controller.signal;

        try {
            // Предварительная оптимизация, быстрая проверка
            if (!form || !form.action) {
                console.error("Форма или действие не указаны.");
                return;
            }

            // Создаем FormData из формы
            const formData = new FormData(form);

            // Показываем прелоадер только один раз
            new CreatePreloader(form.id);

            // Настройки fetch-запроса
            const fetchOptions = {
                method: form.method || 'POST', // POST по умолчанию
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                },
                body: formData,
                signal, // Указываем возможность отмены запроса
            };

            // Выполняем запрос через fetch
            const response = await fetch(form.action, fetchOptions);

            // Проверяем HTTP статус ответа для минимизации обработки
            if (!response.ok) {
                throw new Error(`Ошибка: ${response.status} ${response.statusText}`);
            }

            // Ограничиваем парсинг JSON больших данных
            const contentType = response.headers.get('Content-Type') || '';
            if (contentType.includes('application/json')) {
                const data = await response.json();
                handleSuccess(form, data);

                if (data.data) {
                    try {
                        await sendToOktell(data.data);
                    } catch (error) {
                        console.error('Ошибка при отправке в Oktell:', error.message);
                    }
                }

            } else {
                throw new Error('Некорректный формат ответа');
            }
        } catch (error) {
            // Catch также отслеживает отмену запросов
            if (error.name === 'AbortError') {
                console.warn('Запрос был отменён:', form.id);
            } else {
                handleError(form, error);
            }
        } finally {
            // Очистка действий
            handleFinally(form);
        }

        // Возвращаем функцию для отмены запроса, если потребуется
        return () => controller.abort();
    }

    // Успешная обработка ответа
    function handleSuccess(form, data) {
        if (data && typeof data === 'object') {
            new RemovePreloader(form.id, data.message || 'Успешно', data.status || 'success');
        } else {
            new RemovePreloader(form.id, 'Ответ сервера некорректен', 'error');
        }
    }

    async function sendToOktell(data) {
        try {
            const response = await fetch('https://oktell.aster.uz:8443/aster/website-lead', {
                method: 'POST',
                headers: {
                    'Content-Type': 'text/plain;charset=UTF-8',
                },
                body: JSON.stringify(data)
            });

            // Проверка ответа
            if (!response.ok) {
                throw new Error(`Ошибка отправки на Oktell: ${response.status} ${response.statusText}`);
            }

            const result = await response.json();

            // Если необходимо, можно проверять успешность ответа
            if (result) {
                console.log('Данные успешно отправлены в Oktell:', result);
            } else {
                console.warn('Oktell ответил с ошибкой:', result || 'Неизвестная ошибка');
            }

            return result;
        } catch (error) {
            // Логирование ошибок
            console.error('Ошибка при отправке данных в Oktell:', error.message);
            throw error; // Если нужно передать ошибку дальше
        }
    }

    // Обработка ошибок
    function handleError(form, error) {
        console.error('[Ошибка Fetch]:', error); // Логирование в консоль
        new RemovePreloader(form.id, error.message || 'Ошибка запроса', 'error');
    }

    // Очистка после завершения
    function handleFinally(form) {
        // console.log(`[Запрос завершён] ID формы: ${form.id}`);
        // Добавьте действия в случае необходимости
    }

    // Привязка к обработчику
    feedback.request((form) => {
        const abortRequest = submitFormHandler(form);

        // Пример отмены: сохраним abortRequest для прерывания, если потребуется
        // (например, при переключении страниц)
    });
}
