{strip}
    <div class="model-card">

        <div class="model-card__img">
            <img src="{$equipment.image.original|default:"{$ASSETS_URL}/images/default.jpg"}" alt="{$equipment.model.title}">
        </div>

        <div class="model-card__desc">

            <div class="model-card__part">
                <div class="model-card__item">
                    <div class="text-tmp txt-14 txt-color-accent-5"><p>{$equipment.model.brand}</p></div>
                    <ul class="model-card__desc-name">
                        <li>{$equipment.model.title}</li>
                        <li><span><span style="background-image: url('{$ASSETS_URL}/images/cards/cars/icons/car.svg');"></span> {$equipment.inStock} шт</span></li>
                    </ul>
                </div>

                <div class="model-card__item">
                    <div class="text-tmp txt-14 txt-color-accent-5"><p>Комплектация</p></div>
                    <ul><li>{$equipment.title}</li></ul>
                </div>
            </div>

            <div class="model-card__part">
                <div class="model-card__item">
                    <div class="text-tmp txt-14 txt-color-accent-5"><p>Характеристика</p></div>
                    <ul>
                        <li><span><span style="background-image: url('{$ASSETS_URL}/images/icons/engines/{$equipment.modification.engine}.svg');"></span>{$equipment.modification.name}</span></li>
                        <li><span><span style="background-image: url('{$ASSETS_URL}/images/cards/cars/icons/speed.svg');"></span>0 до 100 км/ч {$equipment.modification.acceleration}</span></li>
                        <li><span><span style="background-image: url('{$ASSETS_URL}/images/icons/gear/{$equipment.modification.gear}.svg');"></span>{$equipment.modification.gearName}</span></li>
                        <li><span><span style="background-image: url('{$ASSETS_URL}/images/icons/fuel/{$equipment.modification.engine}.svg');"></span>{$equipment.modification.engineName}</span></li>
                    </ul>
                </div>
            </div>

            <div class="model-card__part">

                <div class="model-card__part-inner">
                    <div class="model-card__price">
                        <ul>
                            {if $equipment.oldPrice > 0}<li class="old-price">{$equipment.oldPrice|number_format:0:",":" "} сум</li>{/if}
                            <li class="new-price">{$equipment.price|number_format:0:",":" "} сум</li>
                        </ul>
                    </div>

                    <button class="model-card__btn-order" data-model-id="{$equipment.equipmentId}" data-src="modal_model">Забронировать</button>
                </div>
            </div>
        </div>

    </div>
{/strip}